<?php

namespace App\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;

class BladeServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Warehouse permission directive
        Blade::if('warehousePermission', function ($permission) {
            return Auth::check() && Auth::user()->hasPermission($permission);
        });

        // Warehouse access directive
        Blade::if('warehouseAccess', function () {
            return Auth::check() && Auth::user()->hasWarehouseAccess();
        });

        // Warehouse role directives
        Blade::if('warehouseManager', function () {
            return Auth::check() && Auth::user()->isWarehouseManager();
        });

        Blade::if('warehouseSupervisor', function () {
            return Auth::check() && Auth::user()->isWarehouseSupervisor();
        });

        Blade::if('warehouseClerk', function () {
            return Auth::check() && Auth::user()->isWarehouseClerk();
        });

        Blade::if('projectManager', function () {
            return Auth::check() && Auth::user()->isProjectManager();
        });

        Blade::if('warehouseViewer', function () {
            return Auth::check() && Auth::user()->isWarehouseViewer();
        });

        // Multiple permissions (any)
        Blade::if('warehouseAnyPermission', function (...$permissions) {
            return Auth::check() && Auth::user()->hasAnyPermission($permissions);
        });

        // System admin directives
        Blade::if('superAdmin', function () {
            return Auth::check() && Auth::user()->isSuperAdmin();
        });

        Blade::if('systemAdmin', function () {
            return Auth::check() && Auth::user()->isAdmin();
        });

        // System permission directives
        Blade::if('canManageUsers', function () {
            return Auth::check() && Auth::user()->hasPermission('users.view');
        });

        Blade::if('canManageRoles', function () {
            return Auth::check() && Auth::user()->hasPermission('roles.view');
        });

        Blade::if('canManageSettings', function () {
            return Auth::check() && Auth::user()->hasPermission('settings.manage');
        });

        Blade::if('canManageDepartments', function () {
            return Auth::check() && Auth::user()->hasPermission('departments.view');
        });
    }
}