<?php

namespace App\Repositories;

interface BaseRepositoryInterface
{
    /**
     * Get all records with optional filters.
     */
    public function getAll(array $filters = [], array $with = []);

    /**
     * Get paginated records.
     */
    public function getPaginated(array $filters = [], int $perPage = 15, array $with = []);

    /**
     * Find a record by ID.
     */
    public function findById($id, array $with = []);

    /**
     * Find a record by specific field.
     */
    public function findBy(string $field, $value, array $with = []);

    /**
     * Create a new record.
     */
    public function create(array $data);

    /**
     * Update a record.
     */
    public function update($id, array $data);

    /**
     * Delete a record.
     */
    public function delete($id);

    /**
     * Bulk create records.
     */
    public function bulkCreate(array $records);

    /**
     * Search records.
     */
    public function search(string $query, array $fields = [], int $perPage = 15);

    /**
     * Get records count.
     */
    public function count(array $filters = []);

    /**
     * Check if record exists.
     */
    public function exists($id);

    /**
     * Get model instance.
     */
    public function getModel();
}