<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('material_delivery_notes', function (Blueprint $table) {
            $table->id();
            $table->string('mdn_number', 50)->unique();
            $table->foreignId('outgoing_transaction_id')->constrained('outgoing_transactions')->onDelete('restrict');
            $table->date('generated_date');
            $table->string('delivered_to', 200)->nullable();
            $table->string('vehicle_number', 50)->nullable();
            $table->string('driver_name', 100)->nullable();
            $table->string('driver_contact', 20)->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->index('mdn_number');
            $table->index('outgoing_transaction_id');
            $table->index('generated_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('material_delivery_notes');
    }
};
