<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update incoming_operations table
        Schema::table('incoming_operations', function (Blueprint $table) {
            // Add division as text field
            $table->string('division')->after('status')->nullable();

            // Remove fields we no longer need (make them nullable first for safety)
            $table->string('project_phase')->nullable()->change();
            $table->string('site_location')->nullable()->change();
            $table->string('vehicle_number')->nullable()->change();
            $table->string('driver_name')->nullable()->change();
            $table->string('driver_contact')->nullable()->change();
            $table->dateTime('delivery_datetime')->nullable()->change();
        });

        // Update incoming_operation_items table
        Schema::table('incoming_operation_items', function (Blueprint $table) {
            // Add production_date field
            $table->date('production_date')->after('batch_number')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            $table->dropColumn('division');
        });

        Schema::table('incoming_operation_items', function (Blueprint $table) {
            $table->dropColumn('production_date');
        });
    }
};