<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First update existing data to match new status values
        DB::statement("UPDATE outgoing_transactions SET status = 'completed' WHERE status IN ('approved')");

        // Add new enum values temporarily
        DB::statement("ALTER TABLE outgoing_transactions MODIFY COLUMN status ENUM('pending', 'approved', 'completed', 'cancelled', 'successful', 'canceled') DEFAULT 'pending'");

        // Update existing data to match new status values
        DB::statement("UPDATE outgoing_transactions SET status = 'successful' WHERE status IN ('approved', 'completed')");
        DB::statement("UPDATE outgoing_transactions SET status = 'canceled' WHERE status = 'cancelled'");

        // Remove old enum values
        DB::statement("ALTER TABLE outgoing_transactions MODIFY COLUMN status ENUM('pending', 'successful', 'canceled') DEFAULT 'pending'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert back to old status values
        DB::statement("UPDATE outgoing_transactions SET status = 'completed' WHERE status = 'successful'");
        DB::statement("UPDATE outgoing_transactions SET status = 'cancelled' WHERE status = 'canceled'");

        // Restore original enum
        DB::statement("ALTER TABLE outgoing_transactions MODIFY COLUMN status ENUM('pending', 'approved', 'completed', 'cancelled') DEFAULT 'pending'");
    }
};
