<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            // Remove old inspection field (force_close_return already exists)
            $table->dropColumn('requires_inspection');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            // Add back old inspection field
            $table->boolean('requires_inspection')->default(true)->after('delivery_note_number');
        });
    }
};
