<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sync_history', function (Blueprint $table) {
            $table->id();
            $table->string('sync_type')->default('projects'); // Type of sync operation
            $table->string('external_table')->default('project'); // External table name
            $table->integer('total_processed')->default(0);
            $table->integer('imported')->default(0);
            $table->integer('skipped')->default(0);
            $table->integer('errors')->default(0);
            $table->integer('validation_errors')->default(0);
            $table->json('sync_options')->nullable(); // Store sync options
            $table->json('error_details')->nullable(); // Store error details
            $table->json('validation_details')->nullable(); // Store validation details
            $table->enum('status', ['running', 'completed', 'failed', 'cancelled'])->default('running');
            $table->timestamp('started_at');
            $table->timestamp('completed_at')->nullable();
            $table->integer('duration_seconds')->nullable();
            $table->string('triggered_by')->nullable(); // User who triggered the sync
            $table->timestamps();

            // Indexes for performance
            $table->index(['sync_type', 'status']);
            $table->index(['started_at', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sync_history');
    }
};
