<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('direct_deliveries', function (Blueprint $table) {
            // Add reference number for site returns
            $table->string('reference_number')->unique()->after('delivery_number');

            // Add flag to control if items can be returned
            $table->boolean('can_be_returned')->default(true)->after('requires_approval');

            // Add indexes for new columns
            $table->index(['reference_number']);
            $table->index(['can_be_returned']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('direct_deliveries', function (Blueprint $table) {
            $table->dropIndex(['reference_number']);
            $table->dropIndex(['can_be_returned']);
            $table->dropColumn(['reference_number', 'can_be_returned']);
        });
    }
};
