<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('material_transfer_requests', function (Blueprint $table) {
            $table->id();
            $table->string('transfer_request_number')->unique();
            $table->date('request_date');

            // Project Information
            $table->foreignId('transferrer_project_id')->constrained('projects')->onDelete('restrict');
            $table->foreignId('receiver_project_id')->constrained('projects')->onDelete('restrict');

            // Request Details
            $table->string('transfer_reason');
            $table->text('transfer_notes')->nullable();
            $table->enum('priority', ['low', 'medium', 'high', 'urgent'])->default('medium');
            $table->date('required_date')->nullable();

            // Approval Workflow
            $table->enum('status', ['draft', 'pending_transferrer_approval', 'pending_receiver_approval', 'approved', 'rejected', 'cancelled'])->default('draft');

            // Transferrer Project Approval
            $table->foreignId('requested_by')->constrained('users')->onDelete('restrict');
            $table->foreignId('transferrer_approved_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('transferrer_approved_at')->nullable();
            $table->text('transferrer_approval_notes')->nullable();

            // Receiver Project Approval
            $table->foreignId('receiver_approved_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('receiver_approved_at')->nullable();
            $table->text('receiver_approval_notes')->nullable();

            // Rejection Handling
            $table->foreignId('rejected_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('rejected_at')->nullable();
            $table->text('rejection_reason')->nullable();

            // Total Values
            $table->decimal('total_estimated_value', 15, 2)->default(0);
            $table->integer('total_items_count')->default(0);

            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->index(['transferrer_project_id', 'status']);
            $table->index(['receiver_project_id', 'status']);
            $table->index(['request_date']);
            $table->index(['required_date']);
            $table->index(['status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('material_transfer_requests');
    }
};