<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('material_transfer_request_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('transfer_request_id')->constrained('material_transfer_requests')->onDelete('cascade');
            $table->foreignId('item_id')->constrained('items')->onDelete('restrict');

            // Quantity Information
            $table->decimal('quantity_requested', 10, 2);
            $table->decimal('quantity_available', 10, 2)->default(0); // Available in transferrer project
            $table->decimal('quantity_approved', 10, 2)->default(0);
            $table->string('unit_of_measure')->nullable();

            // Pricing Information
            $table->decimal('estimated_unit_price', 10, 2)->nullable();
            $table->decimal('estimated_total_value', 15, 2)->nullable();

            // Specifications
            $table->text('item_specifications')->nullable();
            $table->text('transfer_notes')->nullable();

            // Status Tracking
            $table->enum('approval_status', ['pending', 'approved', 'rejected', 'modified'])->default('pending');
            $table->text('approval_notes')->nullable();

            $table->timestamps();

            // Indexes
            $table->index(['transfer_request_id']);
            $table->index(['item_id']);
            $table->index(['approval_status']);

            // Unique constraint to prevent duplicate items in same request
            $table->unique(['transfer_request_id', 'item_id'], 'mtr_items_request_item_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('material_transfer_request_items');
    }
};