<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('direct_delivery_items', function (Blueprint $table) {
            // Make quantity fields nullable or set default values
            $table->decimal('quantity_delivered', 10, 2)->default(0)->change();
            $table->decimal('quantity_accepted', 10, 2)->default(0)->change();
            $table->decimal('quantity_rejected', 10, 2)->default(0)->change();

            // Also make sure other quantity fields have defaults
            if (Schema::hasColumn('direct_delivery_items', 'quantity_ordered')) {
                $table->decimal('quantity_ordered', 10, 2)->default(0)->change();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('direct_delivery_items', function (Blueprint $table) {
            // Revert changes - remove default values
            $table->decimal('quantity_delivered', 10, 2)->change();
            $table->decimal('quantity_accepted', 10, 2)->change();
            $table->decimal('quantity_rejected', 10, 2)->change();

            if (Schema::hasColumn('direct_delivery_items', 'quantity_ordered')) {
                $table->decimal('quantity_ordered', 10, 2)->change();
            }
        });
    }
};