<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('material_transfer_request_items', function (Blueprint $table) {
            // Column already exists, just add the foreign key
            $table->foreign('material_transfer_item_id', 'mtr_items_mt_item_id_foreign')
                  ->references('id')->on('material_transfer_request_items')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('material_transfer_request_items', function (Blueprint $table) {
            $table->dropForeign('mtr_items_mt_item_id_foreign');
            $table->dropColumn('material_transfer_item_id');
        });
    }
};
