<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incoming_operation_items', function (Blueprint $table) {
            // Drop the wrong foreign key
            $table->dropForeign(['material_transfer_item_id']);

            // Add the correct foreign key pointing to material_transfer_request_items
            $table->foreign('material_transfer_item_id', 'incoming_ops_items_mt_item_id_foreign')
                  ->references('id')->on('material_transfer_request_items')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_operation_items', function (Blueprint $table) {
            $table->dropForeign('incoming_ops_items_mt_item_id_foreign');

            // Restore the original (wrong) foreign key for rollback
            $table->foreign('material_transfer_item_id')->references('id')->on('material_transfer_issue_items')->onDelete('set null');
        });
    }
};
