<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add new status values for multi-source processing
        DB::statement("ALTER TABLE outgoing_transactions MODIFY COLUMN status
            ENUM(
                'pending',
                'successful',
                'canceled',
                'processing',
                'processed_multi_source',
                'converted_to_direct_delivery',
                'converted_to_transfer'
            ) DEFAULT 'pending'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert to original status values
        DB::statement("ALTER TABLE outgoing_transactions MODIFY COLUMN status
            ENUM('pending', 'successful', 'canceled') DEFAULT 'pending'");
    }
};