<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('outgoing_fulfillments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('outgoing_transaction_id')->constrained()->onDelete('cascade');
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');
            $table->decimal('quantity_fulfilled', 10, 2);
            $table->enum('fulfillment_type', ['inventory', 'direct_delivery', 'project_transfer']);
            $table->unsignedBigInteger('reference_id')->nullable(); // ID of the created transaction/delivery/transfer
            $table->string('reference_type')->nullable(); // Type of reference (OutgoingTransaction, DirectDelivery, MaterialTransferRequest)
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->index(['outgoing_transaction_id', 'item_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('outgoing_fulfillments');
    }
};