<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Company News',
                'slug' => 'company',
                'description' => 'Official company announcements and corporate updates',
                'color' => '#038BB9',
                'icon' => 'business',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Announcement',
                'slug' => 'announcement',
                'description' => 'Important announcements and notifications',
                'color' => '#3B82F6',
                'icon' => 'campaign',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Press Release',
                'slug' => 'press',
                'description' => 'Official press releases and media statements',
                'color' => '#6366F1',
                'icon' => 'newspaper',
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'Event',
                'slug' => 'event',
                'description' => 'Company events, conferences, and exhibitions',
                'color' => '#8B5CF6',
                'icon' => 'event',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'Award',
                'slug' => 'award',
                'description' => 'Awards, recognitions, and achievements',
                'color' => '#F59E0B',
                'icon' => 'emoji_events',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Sustainability',
                'slug' => 'sustainability',
                'description' => 'Environmental initiatives and sustainability efforts',
                'color' => '#10B981',
                'icon' => 'eco',
                'is_active' => true,
                'sort_order' => 6,
            ],
            [
                'name' => 'Innovation',
                'slug' => 'innovation',
                'description' => 'Product innovations and technological advances',
                'color' => '#EC4899',
                'icon' => 'lightbulb',
                'is_active' => true,
                'sort_order' => 7,
            ],
            [
                'name' => 'General',
                'slug' => 'general',
                'description' => 'General news and miscellaneous updates',
                'color' => '#6B7280',
                'icon' => 'article',
                'is_active' => true,
                'sort_order' => 8,
            ],
        ];

        foreach ($categories as $category) {
            Category::firstOrCreate(['slug' => $category['slug']], $category);
        }

        $this->command->info('News categories seeded successfully!');
    }
}