<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ProductCategory;
use App\Models\ProductStandard;
use App\Models\Product;

class MirrorGlassSeeder extends Seeder
{
    public function run(): void
    {
        // Create or get Mirror Glass category
        $category = ProductCategory::firstOrCreate(
            ['slug' => 'mirror-glass'],
            [
                'name' => 'Mirror Glass',
                'description' => 'High-quality mirror glass products with European standard specifications',
                'sort_order' => 3,
                'is_active' => true
            ]
        );

        // Create or get European Standard (EN) for Mirror Glass
        $standard = ProductStandard::firstOrCreate(
            [
                'category_id' => $category->id,
                'name' => 'European Standard (EN)'
            ],
            [
                'code' => 'EN',
                'description' => 'European Standard for Mirror Glass products',
                'sort_order' => 1,
                'is_active' => true
            ]
        );

        // Create Silver Mirror product without application (as it has no application mentioned)
        Product::firstOrCreate(
            [
                'name' => 'Silver Mirror',
                'application_id' => null
            ],
            [
                'description' => 'High-quality silver mirror glass manufactured according to European standards. Provides excellent reflection clarity and durability.',
                'features' => 'Superior reflection quality, Durable silver coating, European standard compliance, Versatile applications',
                'thickness_min' => 3.0,
                'thickness_max' => 12.0,
                'thickness_unit' => 'mm',
                'sort_order' => 1,
                'is_featured' => true,
                'is_active' => true
            ]
        );

        echo "Mirror Glass category, standard, and Silver Mirror product created successfully.\n";
    }
}