<?php

namespace Database\Seeders;

use App\Models\Product;
use Illuminate\Database\Seeder;

class OriginalProductsSeeder extends Seeder
{
    public function run(): void
    {
        $products = [
            // Float Glass Products
            [
                'name' => 'ARALUX® Clear Float Glass',
                'slug' => 'aralux-clear-float-glass',
                'description' => 'High-quality clear float glass manufactured by UFG using the latest technology. Perfect transparency and optical clarity for architectural, automotive, and furniture applications.',
                'features' => 'Crystal clear transparency, Excellent optical properties, High strength and durability, UV resistant coating, Available in multiple thicknesses (3mm-19mm), Superior flatness and smooth surface finish',
                'category' => 'float-glass',
                'image' => 'assets/images/products/float-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/float-glass.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 1,
            ],
            [
                'name' => 'ARALUX® Tinted Float Glass',
                'slug' => 'aralux-tinted-float-glass',
                'description' => 'Premium tinted float glass offering excellent solar control and aesthetic appeal. Available in bronze, grey, blue, and green tints.',
                'features' => 'Solar heat reduction, Glare control, Enhanced privacy, Multiple color options (Bronze, Grey, Blue, Green), Energy efficient, Excellent color consistency',
                'category' => 'float-glass',
                'image' => 'assets/images/products/float-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/float-glass.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 2,
            ],
            [
                'name' => 'ARALUX® Low-E Float Glass',
                'slug' => 'aralux-low-e-float-glass', 
                'description' => 'Energy-efficient low-emissivity float glass designed to maximize thermal insulation while maintaining excellent light transmission.',
                'features' => 'Superior thermal insulation, High light transmission, UV protection, Energy cost savings, Reduced heat transfer, Environmentally friendly',
                'category' => 'float-glass',
                'image' => 'assets/images/products/float-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/float-glass.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 3,
            ],
            [
                'name' => 'ARALUX® Extra Clear Float Glass',
                'slug' => 'aralux-extra-clear-float-glass',
                'description' => 'Ultra-clear float glass with minimal iron content for maximum transparency and color neutrality.',
                'features' => 'Ultra-clear transparency, Minimal green tint, Maximum light transmission, Color neutrality, Premium optical quality, Perfect for showcase applications',
                'category' => 'float-glass', 
                'image' => 'assets/images/products/float-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/float-glass.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 4,
            ],

            // Mirror Glass Products
            [
                'name' => 'ARALUX® Silver Mirror',
                'slug' => 'aralux-silver-mirror',
                'description' => 'High-quality silver mirror with excellent reflection properties and superior durability. Perfect for residential and commercial applications.',
                'features' => 'High reflectivity (>90%), Corrosion resistant backing, Moisture protection, Long-lasting silver coating, Multiple thickness options, Easy to cut and process',
                'category' => 'mirror-glass',
                'image' => 'assets/images/products/mirror-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/mirror-glass.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 5,
            ],
            [
                'name' => 'ARALUX® Colored Mirror',
                'slug' => 'aralux-colored-mirror',
                'description' => 'Vibrant colored mirrors available in various colors for decorative and architectural applications.',
                'features' => 'Multiple color options, Vibrant reflections, Decorative applications, Custom colors available, High-quality finish, Excellent color consistency',
                'category' => 'mirror-glass',
                'image' => 'assets/images/products/mirror-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/mirror-glass.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 6,
            ],
            [
                'name' => 'ARALUX® Antique Mirror',
                'slug' => 'aralux-antique-mirror',
                'description' => 'Decorative antique mirror with vintage patterns and textures for unique interior design applications.',
                'features' => 'Vintage appearance, Unique patterns, Artistic finish, Decorative applications, Custom designs available, Handcrafted quality',
                'category' => 'mirror-glass',
                'image' => 'assets/images/products/mirror-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/mirror-glass.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 7,
            ],
            [
                'name' => 'ARALUX® Safety Mirror',
                'slug' => 'aralux-safety-mirror',
                'description' => 'Safety-backed mirror with protective film to prevent shattering and ensure safety in high-traffic areas.',
                'features' => 'Safety backing film, Shatter resistant, High-traffic areas suitable, Enhanced safety, Easy installation, Meets safety standards',
                'category' => 'mirror-glass',
                'image' => 'assets/images/products/mirror-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/mirror-glass.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 8,
            ],

            // Pattern Glass Products
            [
                'name' => 'ARALUX® Fluted Pattern Glass',
                'slug' => 'aralux-fluted-pattern-glass',
                'description' => 'Modern fluted pattern glass with vertical ridges creating elegant light diffusion and contemporary aesthetic appeal.',
                'features' => 'Vertical ridge pattern, Excellent light diffusion, Modern aesthetic, Privacy screening, Architectural appeal, Easy to clean',
                'category' => 'pattern-glass',
                'image' => 'assets/images/products/pattern-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/pattern-glass.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 9,
            ],
            [
                'name' => 'ARALUX® Diamond Pattern Glass',
                'slug' => 'aralux-diamond-pattern-glass',
                'description' => 'Sophisticated diamond pattern glass offering unique geometric design with excellent privacy and light control.',
                'features' => 'Diamond geometric pattern, Privacy control, Unique texture, Light scattering properties, Decorative functionality, Durable surface',
                'category' => 'pattern-glass',
                'image' => 'assets/images/products/pattern-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/pattern-glass.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 10,
            ],
            [
                'name' => 'ARALUX® Rain Pattern Glass',
                'slug' => 'aralux-rain-pattern-glass',
                'description' => 'Beautiful rain pattern glass mimicking natural raindrops, perfect for bathroom and partition applications.',
                'features' => 'Rain drop texture, Water-like appearance, Privacy enhancement, Natural aesthetics, Suitable for wet areas, Easy maintenance',
                'category' => 'pattern-glass',
                'image' => 'assets/images/products/pattern-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/pattern-glass.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 11,
            ],
            [
                'name' => 'ARALUX® Bamboo Pattern Glass',
                'slug' => 'aralux-bamboo-pattern-glass',
                'description' => 'Elegant bamboo pattern glass providing privacy while allowing natural light transmission with beautiful organic texture.',
                'features' => 'Bamboo-inspired pattern, Privacy protection, Natural light transmission, Organic texture, Decorative appeal, Eco-friendly aesthetic',
                'category' => 'pattern-glass',
                'image' => 'assets/images/products/pattern-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/pattern-glass.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 12,
            ],

            // Specialty Glass Products
            [
                'name' => 'ARALUX® Tempered Safety Glass',
                'slug' => 'aralux-tempered-safety-glass',
                'description' => 'High-strength tempered safety glass providing enhanced security and safety for commercial and residential applications.',
                'features' => 'Impact resistant, Safety compliance, Heat treated, Thermal stress resistant, Breakage safety, 4-5x stronger than regular glass',
                'category' => 'safety-glass',
                'image' => 'assets/images/products/float-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/float-glass.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 13,
            ],
            [
                'name' => 'ARALUX® Laminated Safety Glass',
                'slug' => 'aralux-laminated-safety-glass',
                'description' => 'Multi-layer laminated glass offering superior security, sound insulation, and UV protection for demanding applications.',
                'features' => 'Security enhancement, Sound insulation, UV protection (99%), Impact resistance, Interlayer technology, Holds together when broken',
                'category' => 'safety-glass',
                'image' => 'assets/images/products/float-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/float-glass.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 14,
            ],
            [
                'name' => 'ARALUX® Insulated Glass Units (IGU)',
                'slug' => 'aralux-insulated-glass-units',
                'description' => 'High-performance insulated glass units for maximum energy efficiency and thermal comfort in buildings.',
                'features' => 'Superior thermal insulation, Energy efficiency, Condensation control, Noise reduction, Multiple configurations, Argon gas filling available',
                'category' => 'specialty-glass',
                'image' => 'assets/images/products/float-glass.jpg',
                'gallery' => json_encode([
                    'assets/images/products/float-glass.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 15,
            ],
        ];

        foreach ($products as $productData) {
            Product::create($productData);
        }
    }
}