<?php

namespace Database\Seeders;

use App\Models\Video;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class VideoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $videos = [
            [
                'title' => 'UFG Company Overview 2025',
                'description' => 'Discover the story behind UFG\'s success, our values, and our vision for the future. This comprehensive overview showcases our journey, achievements, and commitment to excellence in glass manufacturing.',
                'video_url' => 'https://www.youtube.com/watch?v=dQw4w9WgXcQ',
                'video_type' => 'youtube',
                'thumbnail_url' => null, // Will auto-generate
                'duration' => '5:42',
                'duration_seconds' => 342,
                'category' => 'company',
                'tags' => ['company', 'overview', 'corporate', 'values'],
                'is_featured' => true,
                'is_active' => true,
                'sort_order' => 1,
                'views_count' => 2847,
                'published_at' => now()->subDays(5),
                'meta_title' => 'UFG Company Overview 2025 - Our Story & Vision',
                'meta_description' => 'Watch our comprehensive company overview showcasing UFG\'s journey, achievements, and commitment to excellence in glass manufacturing.'
            ],
            [
                'title' => 'Advanced Glass Manufacturing Process',
                'description' => 'Take a behind-the-scenes look at our state-of-the-art glass manufacturing facilities. See how we combine traditional craftsmanship with cutting-edge technology.',
                'video_url' => 'https://www.youtube.com/watch?v=ScMzIvxBSi4',
                'video_type' => 'youtube',
                'thumbnail_url' => null,
                'duration' => '8:15',
                'duration_seconds' => 495,
                'category' => 'manufacturing',
                'tags' => ['manufacturing', 'process', 'technology', 'quality'],
                'is_featured' => false,
                'is_active' => true,
                'sort_order' => 2,
                'views_count' => 1523,
                'published_at' => now()->subDays(12),
                'meta_title' => 'Advanced Glass Manufacturing Process - UFG',
                'meta_description' => 'Explore our state-of-the-art glass manufacturing process that combines traditional craftsmanship with modern technology.'
            ],
            [
                'title' => 'Innovative Product Showcase 2024',
                'description' => 'Explore our latest product innovations and technological advancements in glass solutions. From decorative mirrors to high-performance float glass.',
                'video_url' => 'https://www.youtube.com/watch?v=M7lc1UVf-VE',
                'video_type' => 'youtube',
                'thumbnail_url' => null,
                'duration' => '6:28',
                'duration_seconds' => 388,
                'category' => 'product',
                'tags' => ['products', 'innovation', 'technology', 'showcase'],
                'is_featured' => false,
                'is_active' => true,
                'sort_order' => 3,
                'views_count' => 987,
                'published_at' => now()->subDays(18),
                'meta_title' => 'Innovative Product Showcase 2024 - UFG Glass Solutions',
                'meta_description' => 'Discover our latest glass product innovations and technological advancements for modern construction and design.'
            ],
            [
                'title' => 'Sustainability & Environmental Commitment',
                'description' => 'Learn about our environmental initiatives and sustainability goals. UFG is committed to reducing our carbon footprint and promoting eco-friendly manufacturing practices.',
                'video_url' => 'https://www.youtube.com/watch?v=ZbZSe6N_BXs',
                'video_type' => 'youtube',
                'thumbnail_url' => null,
                'duration' => '4:33',
                'duration_seconds' => 273,
                'category' => 'sustainability',
                'tags' => ['sustainability', 'environment', 'green', 'eco-friendly'],
                'is_featured' => false,
                'is_active' => true,
                'sort_order' => 4,
                'views_count' => 756,
                'published_at' => now()->subDays(25),
                'meta_title' => 'UFG Sustainability & Environmental Commitment',
                'meta_description' => 'Discover UFG\'s commitment to sustainability and our environmental initiatives for a greener future.'
            ],
            [
                'title' => 'Quality Control & Testing Excellence',
                'description' => 'See how we maintain the highest quality standards through rigorous testing and quality control processes. Every piece of glass meets international standards.',
                'video_url' => 'https://www.youtube.com/watch?v=2Vv-BfVoq4g',
                'video_type' => 'youtube',
                'thumbnail_url' => null,
                'duration' => '7:12',
                'duration_seconds' => 432,
                'category' => 'manufacturing',
                'tags' => ['quality', 'testing', 'standards', 'excellence'],
                'is_featured' => false,
                'is_active' => true,
                'sort_order' => 5,
                'views_count' => 634,
                'published_at' => now()->subDays(32),
                'meta_title' => 'Quality Control & Testing Excellence at UFG',
                'meta_description' => 'Explore UFG\'s rigorous quality control and testing processes that ensure every glass product meets international standards.'
            ],
            [
                'title' => 'Customer Success Stories',
                'description' => 'Hear from our satisfied customers about their experience working with UFG. Real testimonials from architects, contractors, and designers.',
                'video_url' => 'https://www.youtube.com/watch?v=EngW7tLk6R8',
                'video_type' => 'youtube',
                'thumbnail_url' => null,
                'duration' => '9:45',
                'duration_seconds' => 585,
                'category' => 'testimonials',
                'tags' => ['testimonials', 'customers', 'success', 'satisfaction'],
                'is_featured' => false,
                'is_active' => true,
                'sort_order' => 6,
                'views_count' => 412,
                'published_at' => now()->subDays(40),
                'meta_title' => 'Customer Success Stories - UFG Testimonials',
                'meta_description' => 'Watch real customer testimonials and success stories from architects, contractors, and designers who work with UFG.'
            ],
            [
                'title' => 'Installation Guide: Float Glass',
                'description' => 'A comprehensive tutorial on proper float glass installation techniques. Learn the best practices for handling and installing our premium float glass products.',
                'video_url' => 'https://www.youtube.com/watch?v=YQHsXMglC9A',
                'video_type' => 'youtube',
                'thumbnail_url' => null,
                'duration' => '12:20',
                'duration_seconds' => 740,
                'category' => 'tutorials',
                'tags' => ['tutorial', 'installation', 'float-glass', 'guide'],
                'is_featured' => false,
                'is_active' => true,
                'sort_order' => 7,
                'views_count' => 289,
                'published_at' => now()->subDays(48),
                'meta_title' => 'Float Glass Installation Guide - UFG Tutorial',
                'meta_description' => 'Learn proper float glass installation techniques with our comprehensive tutorial and best practice guide.'
            ],
            [
                'title' => 'UFG Innovation Lab Tour',
                'description' => 'Take an exclusive tour of our innovation laboratory where we develop next-generation glass technologies and test new manufacturing processes.',
                'video_url' => 'https://vimeo.com/76979871',
                'video_type' => 'vimeo',
                'thumbnail_url' => null,
                'duration' => '11:08',
                'duration_seconds' => 668,
                'category' => 'innovation',
                'tags' => ['innovation', 'laboratory', 'research', 'technology'],
                'is_featured' => false,
                'is_active' => true,
                'sort_order' => 8,
                'views_count' => 178,
                'published_at' => now()->subDays(55),
                'meta_title' => 'UFG Innovation Lab Tour - Research & Development',
                'meta_description' => 'Take an exclusive tour of UFG\'s innovation laboratory where we develop cutting-edge glass technologies.'
            ],
            [
                'title' => 'Mirror Glass Production Insights',
                'description' => 'Discover the intricate process of creating high-quality mirror glass. From silvering to quality inspection, see every step of our mirror production.',
                'video_url' => 'https://www.youtube.com/watch?v=kJQP7kiw5Fk',
                'video_type' => 'youtube',
                'thumbnail_url' => null,
                'duration' => '6:55',
                'duration_seconds' => 415,
                'category' => 'product',
                'tags' => ['mirror-glass', 'production', 'silvering', 'process'],
                'is_featured' => false,
                'is_active' => true,
                'sort_order' => 9,
                'views_count' => 345,
                'published_at' => now()->subDays(62),
                'meta_title' => 'Mirror Glass Production Process - UFG Insights',
                'meta_description' => 'Learn about UFG\'s high-quality mirror glass production process from silvering to final inspection.'
            ],
            [
                'title' => 'Global Expansion & Future Plans',
                'description' => 'Learn about UFG\'s expansion plans and our vision for the future. Discover how we\'re growing our global presence while maintaining quality excellence.',
                'video_url' => 'https://www.youtube.com/watch?v=aoJyY3HI4_E',
                'video_type' => 'youtube',
                'thumbnail_url' => null,
                'duration' => '8:42',
                'duration_seconds' => 522,
                'category' => 'company',
                'tags' => ['expansion', 'future', 'global', 'growth'],
                'is_featured' => false,
                'is_active' => true,
                'sort_order' => 10,
                'views_count' => 567,
                'published_at' => now()->subDays(70),
                'meta_title' => 'UFG Global Expansion & Future Plans',
                'meta_description' => 'Discover UFG\'s expansion plans and vision for global growth while maintaining our commitment to quality excellence.'
            ]
        ];

        foreach ($videos as $video) {
            Video::create($video);
        }

        $this->command->info('Videos seeded successfully!');
    }
}