<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(\Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = \Illuminate\Http\Request::capture()
);

use App\Models\DirectDelivery;
use App\Models\Warehouse\OutgoingTransaction;

// Get the direct delivery that was created without proper reference
$directDelivery = DirectDelivery::find(5);

if ($directDelivery) {
    echo "Found direct delivery ID: " . $directDelivery->id . "\n";
    echo "Current reference info:\n";
    echo "- Material Request ID: " . ($directDelivery->material_request_id ?? 'NULL') . "\n";
    echo "- Material Request Number: " . ($directDelivery->material_request_number ?? 'NULL') . "\n";
    echo "- Outgoing Transaction ID: " . ($directDelivery->outgoing_transaction_id ?? 'NULL') . "\n";

    // Get the original transaction
    $originalTransaction = OutgoingTransaction::find(1);

    if ($originalTransaction) {
        echo "\nOriginal transaction found:\n";
        echo "- ID: " . $originalTransaction->id . "\n";
        echo "- Material Request Number: " . $originalTransaction->material_request_number . "\n";

        // Update the direct delivery with proper reference
        $directDelivery->update([
            'material_request_number' => $originalTransaction->material_request_number,
            'outgoing_transaction_id' => $originalTransaction->id,
        ]);

        echo "\nUpdated direct delivery with proper reference:\n";
        echo "- Material Request Number: " . $directDelivery->material_request_number . "\n";
        echo "- Outgoing Transaction ID: " . $directDelivery->outgoing_transaction_id . "\n";
    } else {
        echo "Original transaction not found.\n";
    }
} else {
    echo "Direct delivery not found.\n";
}