// Language Dropdown Functionality
document.addEventListener('DOMContentLoaded', function() {
    const languageContainer = document.querySelector('.language-selector');
    const languageText = document.querySelector('.language-selector .language-text');
    
    if (languageContainer && languageText) {
        // Create dropdown menu
        const dropdown = document.createElement('div');
        dropdown.className = 'language-dropdown-menu';
        dropdown.innerHTML = `
            <div class="language-option" data-lang="en">
                <span>English</span>
            </div>
            <div class="language-option" data-lang="ar">
                <span>عربي</span>
            </div>
        `;
        
        // Add dropdown to body for better positioning
        document.body.appendChild(dropdown);
        
        // Position dropdown function
        function positionDropdown() {
            const rect = languageContainer.getBoundingClientRect();
            dropdown.style.top = (rect.bottom + 8) + 'px';
            dropdown.style.left = (rect.left) + 'px';
        }
        
        // Toggle dropdown on click
        languageContainer.addEventListener('click', function(e) {
            e.stopPropagation();
            
            if (dropdown.classList.contains('show')) {
                dropdown.classList.remove('show');
            } else {
                positionDropdown();
                dropdown.classList.add('show');
            }
        });
        
        // Handle language selection
        dropdown.addEventListener('click', function(e) {
            e.stopPropagation();
            const option = e.target.closest('.language-option');
            if (option) {
                const lang = option.dataset.lang;
                const text = option.querySelector('span').textContent;
                
                // Update displayed language
                languageText.textContent = text;
                
                // Close dropdown
                dropdown.classList.remove('show');
                
                // Here you can add actual language switching logic
                console.log('Language switched to:', lang);
            }
        });
        
        // Close dropdown when clicking outside
        document.addEventListener('click', function() {
            dropdown.classList.remove('show');
        });
        
        // Reposition on scroll/resize
        window.addEventListener('scroll', function() {
            if (dropdown.classList.contains('show')) {
                positionDropdown();
            }
        });
        
        window.addEventListener('resize', function() {
            if (dropdown.classList.contains('show')) {
                positionDropdown();
            }
        });
    }
});