// Video System Test - Simple test to verify everything is working
function testVideoSystem() {
    console.log('🧪 Testing Video Management System...');
    
    // Test 1: Check if API is accessible
    console.log('📡 Testing API endpoint...');
    fetch('/api/video-configs')
        .then(response => response.json())
        .then(data => {
            console.log('✅ API Response:', data);
            
            // Test 2: Check video manager
            if (window.videoManager) {
                console.log('✅ Video Manager initialized');
                console.log('📹 Loaded videos:', Object.keys(data));
                
                // Test each video configuration
                Object.entries(data).forEach(([key, config]) => {
                    console.log(`\n📱 Testing ${key}:`);
                    console.log(`   - Type: ${config.type}`);
                    console.log(`   - Video ID: ${config.videoId}`);
                    console.log(`   - Embed URL: ${config.embedUrl}`);
                    console.log(`   - Settings:`, config.settings);
                    console.log(`   - Preload scheduled: ${config.preloadAt ? '✅' : '❌'}`);
                });
                
            } else {
                console.warn('⚠️ Video Manager not found');
            }
            
            // Test 3: Check preloader
            if (window.videoPreloader) {
                console.log('\n✅ Video Preloader initialized');
                
                setTimeout(() => {
                    const metrics = window.videoPreloader.getMetrics();
                    console.log('📊 Preloader Metrics:', metrics);
                }, 2000);
                
            } else {
                console.warn('⚠️ Video Preloader not found');
            }
            
            console.log('\n🎉 Video System Test Complete!');
        })
        .catch(error => {
            console.error('❌ API Test Failed:', error);
        });
}

// Auto-run test if in development mode
if (window.location.hostname === 'localhost' || window.location.hostname.includes('test')) {
    setTimeout(testVideoSystem, 3000);
}

// Export for manual testing
window.testVideoSystem = testVideoSystem;