// Simple Mobile Products - Fallback Approach
(function() {
    'use strict';
    
    console.log('Simple Mobile Products: Script loaded');
    
    function isMobile() {
        return window.innerWidth <= 768;
    }
    
    function addMobileProducts() {
        if (!isMobile()) {
            console.log('Not mobile, skipping');
            return;
        }
        
        if (document.querySelector('.simple-mobile-products')) {
            console.log('Simple mobile products already exists');
            return;
        }
        
        console.log('Adding simple mobile products...');
        
        const mobileProductsHTML = `
            <div class="simple-mobile-products" style="
                background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                padding: 40px 20px;
                margin: 20px 0;
                text-align: center;
                font-family: 'Poppins', sans-serif;
            ">
                <div style="
                    background: linear-gradient(135deg, #038BB9 0%, #1169B5 100%);
                    color: white;
                    padding: 8px 20px;
                    border-radius: 20px;
                    font-size: 12px;
                    font-weight: 600;
                    text-transform: uppercase;
                    letter-spacing: 1px;
                    display: inline-block;
                    margin-bottom: 15px;
                ">Masterpieces</div>
                
                <h2 style="
                    font-size: 32px;
                    font-weight: 700;
                    color: #1a1a1a;
                    margin: 0 0 15px 0;
                ">Our Products</h2>
                
                <p style="
                    font-size: 16px;
                    color: #666;
                    margin: 0 0 30px 0;
                ">Premium glass solutions for every need</p>
                
                <div style="display: flex; flex-direction: column; gap: 20px; max-width: 400px; margin: 0 auto;">
                    <div style="
                        background: white;
                        border-radius: 20px;
                        padding: 20px;
                        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
                        display: flex;
                        align-items: center;
                        gap: 20px;
                        text-align: left;
                    ">
                        <div style="
                            width: 80px;
                            height: 80px;
                            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                            border-radius: 15px;
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            font-weight: bold;
                            color: #038BB9;
                            font-size: 18px;
                        ">CF</div>
                        <div>
                            <h3 style="
                                font-size: 18px;
                                font-weight: 700;
                                color: #038BB9;
                                margin: 0 0 5px 0;
                                text-transform: uppercase;
                            ">Clear Float</h3>
                            <p style="
                                font-size: 14px;
                                color: #666;
                                margin: 0;
                            ">ARALUX® Clear Float Glass</p>
                        </div>
                    </div>
                    
                    <div style="
                        background: white;
                        border-radius: 20px;
                        padding: 20px;
                        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
                        display: flex;
                        align-items: center;
                        gap: 20px;
                        text-align: left;
                    ">
                        <div style="
                            width: 80px;
                            height: 80px;
                            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                            border-radius: 15px;
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            font-weight: bold;
                            color: #038BB9;
                            font-size: 18px;
                        ">SM</div>
                        <div>
                            <h3 style="
                                font-size: 18px;
                                font-weight: 700;
                                color: #038BB9;
                                margin: 0 0 5px 0;
                                text-transform: uppercase;
                            ">Silver Mirror</h3>
                            <p style="
                                font-size: 14px;
                                color: #666;
                                margin: 0;
                            ">ARALUX® Silver Mirror</p>
                        </div>
                    </div>
                    
                    <div style="
                        background: white;
                        border-radius: 20px;
                        padding: 20px;
                        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
                        display: flex;
                        align-items: center;
                        gap: 20px;
                        text-align: left;
                    ">
                        <div style="
                            width: 80px;
                            height: 80px;
                            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                            border-radius: 15px;
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            font-weight: bold;
                            color: #038BB9;
                            font-size: 18px;
                        ">PG</div>
                        <div>
                            <h3 style="
                                font-size: 18px;
                                font-weight: 700;
                                color: #038BB9;
                                margin: 0 0 5px 0;
                                text-transform: uppercase;
                            ">Pattern Glass</h3>
                            <p style="
                                font-size: 14px;
                                color: #666;
                                margin: 0;
                            ">ARALUX® Pattern Glass</p>
                        </div>
                    </div>
                    
                    <div style="
                        background: white;
                        border-radius: 20px;
                        padding: 20px;
                        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
                        display: flex;
                        align-items: center;
                        gap: 20px;
                        text-align: left;
                    ">
                        <div style="
                            width: 80px;
                            height: 80px;
                            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                            border-radius: 15px;
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            font-weight: bold;
                            color: #038BB9;
                            font-size: 18px;
                        ">DM</div>
                        <div>
                            <h3 style="
                                font-size: 18px;
                                font-weight: 700;
                                color: #038BB9;
                                margin: 0 0 5px 0;
                                text-transform: uppercase;
                            ">Decorative Mirror</h3>
                            <p style="
                                font-size: 14px;
                                color: #666;
                                margin: 0;
                            ">ARALUX® Decorative Mirror</p>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        // Try to find the best insertion point
        let insertAfter = document.querySelector('.stats-counter-section'); // After the numbers section
        
        if (!insertAfter) {
            insertAfter = document.querySelector('.main-content'); // Main content area
        }
        
        if (!insertAfter) {
            insertAfter = document.querySelector('main'); // Main content
        }
        
        if (!insertAfter) {
            insertAfter = document.body; // Last resort
        }
        
        if (insertAfter) {
            if (insertAfter.tagName === 'MAIN' || insertAfter.tagName === 'BODY') {
                insertAfter.insertAdjacentHTML('beforeend', mobileProductsHTML);
            } else {
                insertAfter.insertAdjacentHTML('afterend', mobileProductsHTML);
            }
            console.log('Simple mobile products added successfully');
        } else {
            console.error('Could not find insertion point');
        }
    }
    
    // Try multiple times to ensure it works
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', addMobileProducts);
    } else {
        addMobileProducts();
    }
    
    // Also try after a delay
    setTimeout(addMobileProducts, 1000);
    setTimeout(addMobileProducts, 2000);
    
    // Handle window resize
    window.addEventListener('resize', function() {
        setTimeout(addMobileProducts, 500);
    });
    
})();