@extends('layouts.admin-simple')

@section('title', 'Dashboard')
@section('page-title', 'Dashboard')
@section('page-subtitle', 'Overview of warehouse operations and key metrics')

@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
@endsection

@section('content')
    <!-- Dashboard Stats -->
    <x-warehouse.dashboard-stats />

    <!-- Quick Actions & Recent Activity -->
    <div class="row">
        <!-- Quick Actions -->
        <div class="col-lg-4 mb-4">
            <div class="card warehouse-card h-100">
                <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">flash_on</i>
                        Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <div class="warehouse-quick-actions">
                        @if(auth()->user()->hasPermission('warehouse.incoming.create'))
                        <a href="{{ route('warehouse.incoming-operations.create') }}" class="warehouse-quick-action-btn">
                            <div class="d-flex align-items-center p-3 mb-2 bg-light rounded">
                                <i class="material-icons text-primary mr-3">input</i>
                                <div>
                                    <div class="font-weight-medium">Receive Goods</div>
                                    <small class="text-muted">Record incoming shipment</small>
                                </div>
                            </div>
                        </a>
                        @endif

                        @if(auth()->user()->hasPermission('warehouse.outgoing.create'))
                        <a href="{{ route('warehouse.outgoing.create') }}" class="warehouse-quick-action-btn">
                            <div class="d-flex align-items-center p-3 mb-2 bg-light rounded">
                                <i class="material-icons text-success mr-3">output</i>
                                <div>
                                    <div class="font-weight-medium">Dispatch Goods</div>
                                    <small class="text-muted">Create outgoing shipment</small>
                                </div>
                            </div>
                        </a>
                        @endif

                        @if(auth()->user()->hasPermission('warehouse.inventory.adjust'))
                        <a href="{{ route('warehouse.inventory.adjustments') }}" class="warehouse-quick-action-btn">
                            <div class="d-flex align-items-center p-3 mb-2 bg-light rounded">
                                <i class="material-icons text-warning mr-3">tune</i>
                                <div>
                                    <div class="font-weight-medium">Adjust Stock</div>
                                    <small class="text-muted">Update inventory levels</small>
                                </div>
                            </div>
                        </a>
                        @endif

                        @if(auth()->user()->hasPermission('warehouse.items.create'))
                        <a href="{{ route('warehouse.items.create') }}" class="warehouse-quick-action-btn">
                            <div class="d-flex align-items-center p-3 mb-2 bg-light rounded">
                                <i class="material-icons text-info mr-3">add_box</i>
                                <div>
                                    <div class="font-weight-medium">Add New Item</div>
                                    <small class="text-muted">Register new inventory item</small>
                                </div>
                            </div>
                        </a>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="col-lg-8 mb-4">
            <div class="card warehouse-card h-100">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <h6 class="card-title mb-0">
                            <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">history</i>
                            Recent Transactions
                        </h6>
                        <a href="{{ route('warehouse.reports.transactions') }}" class="btn btn-outline-primary btn-sm">
                            View All
                        </a>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @php
                            $recentTransactions = \App\Models\Warehouse\IncomingTransaction::with(['supplier', 'items'])->latest()->take(5)->get();
                        @endphp
                        @forelse($recentTransactions as $transaction)
                        <div class="list-group-item border-0">
                            <div class="d-flex align-items-center">
                                <div class="warehouse-activity-icon mr-3">
                                    <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center"
                                         style="width: 40px; height: 40px;">
                                        <i class="material-icons" style="font-size: 18px;">input</i>
                                    </div>
                                </div>
                                <div class="flex-fill">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div>
                                            <div class="font-weight-medium">
                                                Incoming: {{ $transaction->reference_number }}
                                            </div>
                                            <small class="text-muted">
                                                From {{ $transaction->supplier->name ?? 'Unknown Supplier' }} •
                                                {{ $transaction->items_count ?? 0 }} items •
                                                {{ $transaction->created_at->diffForHumans() }}
                                            </small>
                                        </div>
                                        <span class="badge badge-{{ $transaction->status === 'completed' ? 'success' : 'warning' }}">
                                            {{ ucfirst($transaction->status) }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="list-group-item border-0 text-center py-4">
                            <i class="material-icons text-muted mb-2" style="font-size: 32px;">inbox</i>
                            <p class="text-muted mb-0">No recent transactions</p>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts & Reports -->
    <div class="row">
        <!-- Inventory Chart -->
        <div class="col-lg-8 mb-4">
            <div class="card warehouse-card">
                <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">bar_chart</i>
                        Inventory Levels by Category
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="inventoryChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <!-- Top Items -->
        <div class="col-lg-4 mb-4">
            <div class="card warehouse-card">
                <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">trending_up</i>
                        Top Moving Items
                    </h6>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @php
                            $topItems = \App\Models\Warehouse\Item::with('inventories')
                                ->get()
                                ->map(function($item) {
                                    $item->total_inventory_quantity = $item->inventories->sum('quantity_available');
                                    return $item;
                                })
                                ->sortByDesc('total_inventory_quantity')
                                ->take(5);
                        @endphp
                        @forelse($topItems as $item)
                        <div class="list-group-item border-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="font-weight-medium">{{ $item->item_description }}</div>
                                    <small class="text-muted">{{ $item->item_code }}</small>
                                </div>
                                <div class="text-right">
                                    <div class="font-weight-bold text-primary">{{ $item->total_inventory_quantity ?? 0 }}</div>
                                    <small class="text-muted">{{ $item->unit_of_measure }}</small>
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="list-group-item border-0 text-center py-4">
                            <p class="text-muted mb-0">No item data available</p>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Sample inventory chart
    var ctx = document.getElementById('inventoryChart').getContext('2d');
    var inventoryChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Electronics', 'Hardware', 'Tools', 'Materials', 'Equipment'],
            datasets: [{
                label: 'Stock Level',
                data: [120, 190, 30, 50, 80],
                backgroundColor: [
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)',
                    'rgba(153, 102, 255, 0.8)'
                ],
                borderColor: [
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 99, 132, 1)',
                    'rgba(255, 205, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            },
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });
});
</script>
@endpush