<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Admin Login - {{ config('app.name') }}</title>

    <!-- Admin Favicon -->
    <link rel="icon" type="image/png" href="{{ asset($siteSettings['admin_favicon'] ?? $siteSettings['site_favicon'] ?? 'images/favicon.ico') }}">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

    <!-- Admin CSS -->
    <link type="text/css" href="{{ asset('admin-assets/css/app.css') }}" rel="stylesheet">
    
    <!-- Custom Login Background -->
    <style>
        [dir] .layout-login {
            background-image: url("{{ asset('assets/2025/08/abc.jpeg') }}") !important;
        }
        @media (max-width: 576px) {
            .navbar-brand-text {
                font-size: 18px !important;
            }
        }
        @media (max-width: 480px) {
            .navbar-brand-text {
                display: none !important;
            }
        }
    </style>
</head>

<body class="layout-login">
    <div class="layout-login__overlay"></div>
    <div class="layout-login__form bg-white">
        <div class="mt-2 mb-5 navbar-light">
            <a href="{{ url('/') }}" class="navbar-brand d-flex align-items-center justify-content-center" style="min-width: 0">
                <img class="navbar-brand-icon mr-3" src="{{ asset($siteSettings['site_logo'] ?? 'assets/images/admin-logo.svg') }}" style="height: 60px;" alt="{{ $siteSettings['site_name'] ?? 'AUFG' }}">
                <span class="navbar-brand-text font-weight-bold" style="font-size: 24px; color: #2c3e50;">{{ $siteSettings['site_name'] ?? 'KCG Inventory' }}</span>
            </a>
        </div>

        <h4 class="m-0">Welcome back!</h4>
        <p class="mb-5">Login to access your Admin Panel</p>

        @if ($errors->any())
            <div class="alert alert-danger" role="alert">
                @foreach ($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        @endif

        <form method="POST" action="{{ route('admin.login.post') }}" novalidate>
            @csrf
            <div class="form-group">
                <label class="text-label" for="email">Email Address:</label>
                <div class="input-group input-group-merge">
                    <input id="email"
                           type="email"
                           name="email"
                           value=""
                           required
                           class="form-control form-control-prepended"
                           placeholder="Enter your mail ID">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <span class="far fa-envelope"></span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="form-group">
                <label class="text-label" for="password">Password:</label>
                <div class="input-group input-group-merge">
                    <input id="password"
                           type="password"
                           name="password"
                           value=""
                           required
                           class="form-control form-control-prepended"
                           placeholder="Enter your password">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <span class="fa fa-key"></span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="form-group mb-5">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" 
                           name="remember"
                           class="custom-control-input" 
                           id="remember">
                    <label class="custom-control-label" for="remember">Remember me</label>
                </div>
            </div>
            
            <div class="form-group text-center">
                <button class="btn btn-primary mb-4" type="submit">Login to Admin Panel</button><br>
                <a href="{{ url('/') }}">← Back to Website</a>
            </div>
        </form>

        <!-- Demo Credentials -->
        <!-- <div class="alert alert-info mt-4" role="alert">
            <h6 class="alert-heading">Admin Credentials:</h6>
            <p class="mb-1"><strong>Email:</strong> admin@kcg.com</p>
            <p class="mb-0"><strong>Password:</strong> Qwerty@123</p>
        </div> -->
    </div>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>

    <!-- Admin JS -->
    <script src="{{ asset('admin-assets/js/app.js') }}"></script>
</body>
</html>