@extends('layouts.admin-simple')

@section('title', 'User Management')
@section('page-title', 'User Management')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active" aria-current="page">Users</li>
@endsection

@section('page-actions')
    @if(auth()->user()->hasPermission('create_users'))
    <div class="ml-auto">
        <button class="btn btn-primary" data-toggle="modal" data-target="#createUserModal">
            <i class="material-icons">add</i> Add User
        </button>
    </div>
    @endif
@endsection

@section('content')
    <!-- Filters -->
    <div class="card mb-3">
        <div class="card-body">
            <form method="GET" class="row align-items-end">
                <div class="col-md-3">
                    <label for="search" class="form-label">Search</label>
                    <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Name, email, employee ID...">
                </div>
                <div class="col-md-2">
                    <label for="role" class="form-label">Role</label>
                    <select class="form-control" id="role" name="role">
                        <option value="">All Roles</option>
                        @foreach($roles as $role)
                            <option value="{{ $role->name }}" {{ request('role') == $role->name ? 'selected' : '' }}>
                                {{ $role->display_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="status" class="form-label">Status</label>
                    <select class="form-control" id="status" name="status">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="suspended" {{ request('status') == 'suspended' ? 'selected' : '' }}>Suspended</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="department" class="form-label">Department</label>
                    <select class="form-control" id="department" name="department">
                        <option value="">All Departments</option>
                        @foreach($departments as $dept)
                            <option value="{{ $dept }}" {{ request('department') == $dept ? 'selected' : '' }}>{{ $dept }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-outline-primary">
                        <i class="material-icons">search</i> Search
                    </button>
                    <a href="{{ route('admin.users') }}" class="btn btn-outline-secondary">
                        <i class="material-icons">clear</i> Clear
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Users Table -->
    <div class="card">
        <div class="card-header card-header-large bg-white d-flex align-items-center">
            <div class="flex">
                <h4 class="card-header__title">Users</h4>
                <div class="card-subtitle text-muted">Manage system users and their roles</div>
            </div>
            <div class="ml-auto">
                <span class="badge badge-light">{{ $users->total() }} total users</span>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Role</th>
                        <th>Department</th>
                        <th>Status</th>
                        <th>Last Login</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($users as $user)
                    <tr>
                        <td>
                            <div class="media align-items-center">
                                <div class="avatar avatar-sm mr-3">
                                    <img src="{{ $user->avatar_url }}" alt="{{ $user->full_name }}" class="avatar-img rounded-circle">
                                </div>
                                <div class="media-body">
                                    <strong>{{ $user->full_name }}</strong>
                                    <div class="text-muted small">{{ $user->email }}</div>
                                    @if($user->employee_id)
                                        <div class="text-muted small">ID: {{ $user->employee_id }}</div>
                                    @endif
                                </div>
                            </div>
                        </td>
                        <td>
                            @if($user->role)
                                <span class="badge badge-soft-info">{{ $user->role->display_name }}</span>
                            @else
                                <span class="badge badge-soft-secondary">No Role</span>
                            @endif
                        </td>
                        <td>{{ $user->department ?? 'N/A' }}</td>
                        <td>
                            @php
                                $statusClass = match($user->status) {
                                    'active' => 'badge-soft-success',
                                    'inactive' => 'badge-soft-warning',
                                    'suspended' => 'badge-soft-danger',
                                    default => 'badge-soft-secondary'
                                };
                            @endphp
                            <span class="badge {{ $statusClass }}">{{ ucfirst($user->status) }}</span>
                            @if($user->first_login)
                                <span class="badge badge-soft-info badge-sm">First Login</span>
                            @endif
                        </td>
                        <td>
                            @if($user->last_login_at)
                                <span class="text-muted small">{{ $user->last_login_at->format('M d, Y H:i') }}</span>
                            @else
                                <span class="text-muted small">Never</span>
                            @endif
                        </td>
                        <td>
                            <div class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" data-caret="false">
                                    <i class="material-icons">more_vert</i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <a href="#" class="dropdown-item" data-toggle="modal" data-target="#viewUserModal{{ $user->id }}">
                                        <i class="material-icons mr-2">visibility</i> View Details
                                    </a>
                                    @if(auth()->user()->hasPermission('edit_users'))
                                        <a href="#" class="dropdown-item" data-toggle="modal" data-target="#editUserModal{{ $user->id }}">
                                            <i class="material-icons mr-2">edit</i> Edit User
                                        </a>
                                        <a href="#" class="dropdown-item text-warning" onclick="resetPassword({{ $user->id }})">
                                            <i class="material-icons mr-2">vpn_key</i> Reset Password
                                        </a>
                                    @endif
                                    @if(auth()->user()->hasPermission('delete_users') && $user->id !== auth()->id())
                                        <div class="dropdown-divider"></div>
                                        <a href="#" class="dropdown-item text-danger" data-toggle="modal" data-target="#deleteUserModal{{ $user->id }}">
                                            <i class="material-icons mr-2">delete</i> Delete User
                                        </a>
                                    @endif
                                </div>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-4">
                            <div class="empty-state">
                                <i class="material-icons mb-3" style="font-size: 48px; color: #ddd;">people_outline</i>
                                <h5 class="text-muted">No users found</h5>
                                <p class="text-muted">
                                    @if(request()->hasAny(['search', 'role', 'status', 'department']))
                                        Try adjusting your search criteria or <a href="{{ route('admin.users') }}">clear filters</a>.
                                    @else
                                        Users will appear here when they are created.
                                    @endif
                                </p>
                                @if(auth()->user()->hasPermission('create_users'))
                                    <button class="btn btn-primary" data-toggle="modal" data-target="#createUserModal">
                                        <i class="material-icons">add</i> Add First User
                                    </button>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($users->hasPages())
            <div class="card-footer">
                {{ $users->appends(request()->query())->links('pagination::flowdash') }}
            </div>
        @endif
    </div>
@endsection

@section('modals')
    @if(auth()->user()->hasPermission('create_users'))
        @include('admin.users.modals.create')
    @endif
    
    @foreach($users as $user)
        @include('admin.users.modals.view', ['user' => $user])
        
        @if(auth()->user()->hasPermission('edit_users'))
            @include('admin.users.modals.edit', ['user' => $user])
        @endif
        
        @if(auth()->user()->hasPermission('delete_users') && $user->id !== auth()->id())
            @include('admin.users.modals.delete', ['user' => $user])
        @endif
    @endforeach
@endsection

@push('scripts')
<script>
function resetPassword(userId) {
    if (confirm('Are you sure you want to reset this user\'s password?')) {
        fetch(`/admin/users/${userId}/reset-password`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(`Password reset successfully!\nTemporary password: ${data.temp_password}\n\nPlease provide this to the user securely.`);
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while resetting the password.');
        });
    }
}
</script>
@endpush