<!-- Global Header Component -->
<header class="aufg-global-header" id="aufgGlobalHeader">
	<div class="aufg-header-wrapper">
		<div class="aufg-header-container">
			<!-- Logo Section -->
			<div class="aufg-logo-section">
				<a href="{{ route('home') }}" class="aufg-logo-link" title="Go to Home Page">
					<img src="{{ asset('images/aufg-logo.png') }}" class="aufg-logo" alt="UFG Logo" />
				</a>
			</div>
			
			<!-- Navigation Section -->
			<nav class="aufg-nav-section" aria-label="Main Navigation">
				<ul class="aufg-nav-menu" id="aufgNavMenu">
					<li class="aufg-nav-item">
						<a href="{{ route('home') }}" class="aufg-nav-link">Home</a>
					</li>
					<li class="aufg-nav-item">
						<a href="{{ route('about') }}" class="aufg-nav-link">About Us</a>
					</li>
					<li class="aufg-nav-item aufg-has-dropdown">
						<a href="{{ route('products') }}" class="aufg-nav-link">
							Products
							<i class="fa fa-chevron-down"></i>
						</a>
						<ul class="aufg-dropdown-menu">
							<li>
								<a href="{{ route('products') }}">
									<div class="aufg-dropdown-content">
										<span class="aufg-dropdown-title">All Products</span>
										<span class="aufg-dropdown-description">Complete range of glass products and solutions</span>
									</div>
								</a>
							</li>
							<li>
								<a href="{{ route('products.float-glass') }}">
									<div class="aufg-dropdown-content">
										<span class="aufg-dropdown-title">Float Glass</span>
										<span class="aufg-dropdown-description">Premium quality float glass to international standards</span>
									</div>
								</a>
							</li>
							<li>
								<a href="{{ route('products.pattern-glass') }}">
									<div class="aufg-dropdown-content">
										<span class="aufg-dropdown-title">Pattern Glass</span>
										<span class="aufg-dropdown-description">Decorative glass with unique textures and designs</span>
									</div>
								</a>
							</li>
							<li>
								<a href="{{ route('products.mirror-glass') }}">
									<div class="aufg-dropdown-content">
										<span class="aufg-dropdown-title">Mirror Glass</span>
										<span class="aufg-dropdown-description">High-quality silver mirrors for all applications</span>
									</div>
								</a>
							</li>
							<li>
								<a href="{{ route('products.decorative-mirror') }}">
									<div class="aufg-dropdown-content">
										<span class="aufg-dropdown-title">Decorative Mirror</span>
										<span class="aufg-dropdown-description">Elegant decorative mirrors for interior design</span>
									</div>
								</a>
							</li>
						</ul>
					</li>
					<li class="aufg-nav-item">
						<a href="{{ route('quality') }}" class="aufg-nav-link">Quality</a>
					</li>
					<li class="aufg-nav-item">
						<a href="{{ route('investors') }}" class="aufg-nav-link">Investors</a>
					</li>
					<li class="aufg-nav-item aufg-has-dropdown">
						<a href="#" class="aufg-nav-link">
							Media
							<i class="fa fa-chevron-down"></i>
						</a>
						<ul class="aufg-dropdown-menu">
							<li>
								<a href="{{ route('news') }}">
									<div class="aufg-dropdown-content">
										<span class="aufg-dropdown-title">News</span>
										<span class="aufg-dropdown-description">Latest company announcements and press releases</span>
									</div>
								</a>
							</li>
							<li>
								<a href="{{ route('videos') }}">
									<div class="aufg-dropdown-content">
										<span class="aufg-dropdown-title">Videos</span>
										<span class="aufg-dropdown-description">Product showcases and company presentations</span>
									</div>
								</a>
							</li>
						</ul>
					</li>
					<li class="aufg-nav-item">
						<a href="{{ route('careers') }}" class="aufg-nav-link">Careers</a>
					</li>
					<li class="aufg-nav-item">
						<a href="{{ route('contact') }}" class="aufg-nav-link">Contact Us</a>
					</li>
				</ul>
			</nav>
			
			<!-- Actions Section -->
			<div class="aufg-actions-section">
				<!-- Login Button -->
				<a href="#" class="aufg-btn aufg-btn-login">
					<span>Login</span>
				</a>
				
				<!-- Language Selector -->
				<div class="aufg-language-selector">
					<button class="aufg-lang-btn" id="aufgLangToggle" aria-label="Select Language">
						<svg class="aufg-globe-icon" width="20" height="20" viewBox="0 0 24 24" fill="none">
							<circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
							<path d="M12 2C12 2 16 6 16 12C16 18 12 22 12 22" stroke="currentColor" stroke-width="2"/>
							<path d="M12 2C12 2 8 6 8 12C8 18 12 22 12 22" stroke="currentColor" stroke-width="2"/>
							<line x1="2" y1="12" x2="22" y2="12" stroke="currentColor" stroke-width="2"/>
							<path d="M4.93 7H19.07" stroke="currentColor" stroke-width="2"/>
							<path d="M4.93 17H19.07" stroke="currentColor" stroke-width="2"/>
						</svg>
						<span class="aufg-current-lang">EN</span>
						<svg class="aufg-dropdown-arrow" width="12" height="8" viewBox="0 0 12 8" fill="none">
							<path d="M1 1L6 6L11 1" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
						</svg>
					</button>
					<div class="aufg-lang-dropdown" id="aufgLangDropdown">
						<button class="aufg-lang-option" data-lang="en">
							<span class="aufg-lang-flag">🇬🇧</span>
							<span class="aufg-lang-name">English</span>
						</button>
						<button class="aufg-lang-option" data-lang="ar">
							<span class="aufg-lang-flag">🇸🇦</span>
							<span class="aufg-lang-name">العربية</span>
						</button>
					</div>
				</div>
				
				<!-- Mobile Menu Toggle -->
				<button class="aufg-menu-toggle" id="aufgMenuToggle" aria-label="Toggle Menu" aria-expanded="false">
					<span class="aufg-menu-icon">
						<span></span>
						<span></span>
						<span></span>
					</span>
				</button>
			</div>
		</div>
	</div>
	
	<!-- Mobile Navigation -->
	<div class="aufg-mobile-nav" id="aufgMobileNav">
		<ul class="aufg-mobile-menu">
			<li><a href="{{ route('home') }}">Home</a></li>
			<li><a href="{{ route('about') }}">About Us</a></li>
			<li class="aufg-has-submenu">
				<a href="{{ route('products') }}">Products</a>
				<ul class="aufg-submenu">
					<li><a href="{{ route('products') }}">All Products</a></li>
					<li><a href="{{ route('products.float-glass') }}">Float Glass</a></li>
					<li><a href="{{ route('products.pattern-glass') }}">Pattern Glass</a></li>
					<li><a href="{{ route('products.mirror-glass') }}">Mirror Glass</a></li>
					<li><a href="{{ route('products.decorative-mirror') }}">Decorative Mirror</a></li>
				</ul>
			</li>
			<li><a href="{{ route('quality') }}">Quality</a></li>
			<li><a href="{{ route('investors') }}">Investors</a></li>
			<li class="aufg-has-submenu">
				<a href="#">Media</a>
				<ul class="aufg-submenu">
					<li><a href="{{ route('news') }}">News</a></li>
					<li><a href="{{ route('videos') }}">Videos</a></li>
				</ul>
			</li>
			<li><a href="{{ route('careers') }}">Careers</a></li>
			<li><a href="{{ route('contact') }}">Contact Us</a></li>
		</ul>
	</div>
</header>