{{-- Newsletter Subscription Form --}}
<form class="w-full max-w-md" action="{{ route('newsletter.subscribe') }}" method="POST" id="newsletterForm">
    @csrf
    
    <div class="flex flex-col sm:flex-row gap-3">
        <div class="flex-1">
            <input type="email" 
                   name="email"
                   placeholder="Enter your email" 
                   required
                   class="w-full px-4 py-3 bg-white/10 border border-white/20 rounded-lg text-white placeholder-white/60 focus:outline-none focus:ring-2 focus:ring-aufg-blue focus:border-transparent transition-all duration-300 font-poppins">
        </div>
        <button type="submit" 
                class="px-6 py-3 bg-aufg-blue hover:bg-aufg-light-blue text-white font-medium rounded-lg transition-all duration-300 transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-aufg-blue focus:ring-offset-2 focus:ring-offset-transparent font-poppins">
            Subscribe
        </button>
    </div>
    
    <p class="text-white/70 text-sm mt-3 text-center sm:text-left font-poppins">
        By subscribing you agree to our 
        <a href="#" class="text-aufg-blue hover:text-white transition-colors">Privacy Policy</a>
    </p>
</form>

@push('scripts')
<script>
document.getElementById('newsletterForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const form = this;
    const email = form.querySelector('input[name="email"]').value;
    const button = form.querySelector('button[type="submit"]');
    const originalText = button.textContent;
    
    // Show loading state
    button.textContent = 'Subscribing...';
    button.disabled = true;
    
    // Simulate API call (replace with actual implementation)
    fetch(form.action, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({ email: email })
    })
    .then(response => response.json())
    .then(data => {
        // Show success message
        button.textContent = 'Subscribed!';
        button.classList.add('bg-green-600');
        form.querySelector('input[name="email"]').value = '';
        
        // Reset after 3 seconds
        setTimeout(() => {
            button.textContent = originalText;
            button.disabled = false;
            button.classList.remove('bg-green-600');
        }, 3000);
    })
    .catch(error => {
        console.error('Error:', error);
        button.textContent = 'Try Again';
        button.disabled = false;
        
        setTimeout(() => {
            button.textContent = originalText;
        }, 3000);
    });
});
</script>
@endpush