@props([
    'name',
    'id' => $name,
    'label' => '',
    'required' => false,
    'placeholder' => 'Please select...',
    'options' => [],
    'selected' => null,
    'allowClear' => true,
    'multiple' => false,
    'disabled' => false,
    'help' => '',
    'errorField' => $name,
    'class' => '',
    'data' => [],
    'ajax' => null,
    'theme' => 'default'
])

<div class="form-group">
    @if($label)
        <label for="{{ $id }}" class="form-label">
            {{ $label }}
            @if($required)
                <span class="text-danger">*</span>
            @endif
        </label>
    @endif

    <select
        name="{{ $name }}"
        id="{{ $id }}"
        class="form-control select2-dropdown {{ $class }} @error($errorField) is-invalid @enderror"
        @if($required) required @endif
        @if($disabled) disabled @endif
        @if($multiple) multiple @endif
        @foreach($data as $key => $value)
            @if($key === 'onchange')
                onchange="{{ $value }}"
            @else
                data-{{ $key }}="{{ $value }}"
            @endif
        @endforeach
    >
        @if(!$multiple && !$ajax)
            <option value="">{{ $placeholder }}</option>
        @endif

        @foreach($options as $option)
            @if(is_array($option))
                <option
                    value="{{ $option['value'] }}"
                    {{ (string) $selected === (string) $option['value'] ? 'selected' : '' }}
                    @if(isset($option['data']))
                        @foreach($option['data'] as $dataKey => $dataValue)
                            data-{{ $dataKey }}="{{ $dataValue }}"
                        @endforeach
                    @endif
                >
                    {{ $option['text'] }}
                </option>
            @else
                <option
                    value="{{ $option->id }}"
                    {{ (string) $selected === (string) $option->id ? 'selected' : '' }}
                >
                    {{ $option->name ?? $option->text ?? $option }}
                </option>
            @endif
        @endforeach
    </select>

    @error($errorField)
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror

    @if($help)
        <small class="form-text text-muted">{{ $help }}</small>
    @endif
</div>

@push('styles')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css">
    <style>
        .select2-container {
            width: 100% !important;
        }

        .select2-container .select2-selection--single {
            height: 38px;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container .select2-selection--multiple {
            min-height: 38px;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
            padding-left: 12px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 36px;
        }

        .select2-dropdown {
            border-radius: 0.375rem;
            border: 1px solid #ced4da;
        }

        .select2-search__field {
            border: 1px solid #ced4da !important;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-results__option--highlighted[aria-selected] {
            background-color: #007bff;
        }

        .select2-container--default .select2-results__option[aria-selected=true] {
            background-color: #e7f3ff;
            color: #495057;
        }

        /* Error state */
        .select2-container--default .select2-selection--single.is-invalid,
        .select2-container--default .select2-selection--multiple.is-invalid,
        .select2-container .select2-selection.is-invalid {
            border-color: #dc3545 !important;
            box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
        }

        /* Disabled state */
        .select2-container--default .select2-selection--single[disabled],
        .select2-container--default .select2-selection--multiple[disabled] {
            background-color: #e9ecef;
            border-color: #ced4da;
        }
    </style>
@endpush

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize Select2 for this specific dropdown
            $('#{{ $id }}').select2({
                placeholder: '{{ $placeholder }}',
                allowClear: {{ $allowClear ? 'true' : 'false' }},
                theme: '{{ $theme }}',
                width: '100%',
                dropdownAutoWidth: true,
                @if($ajax)
                ajax: {!! json_encode($ajax) !!},
                @endif
                language: {
                    noResults: function() {
                        return 'No results found';
                    },
                    searching: function() {
                        return 'Searching...';
                    }
                }
            });

            @if($multiple)
            // Handle multiple selection changes
            $('#{{ $id }}').on('select2:select select2:unselect', function (e) {
                $(this).trigger('change');
            });
            @endif

            // Prevent Select2 events from interfering with Bootstrap dropdowns
            $('#{{ $id }}').on('select2:open select2:close', function(e) {
                e.stopPropagation();
            });

            // Handle dropdown clicks to prevent Bootstrap dropdown interference
            $('#{{ $id }}').next('.select2-container').on('click', function(e) {
                e.stopPropagation();
            });
        });
    </script>
@endpush