<aside class="warehouse-sidebar" style="width: 280px;">
    <div class="p-3">
        <!-- Dashboard -->
        <div class="mb-3">
            <a href="{{ route('warehouse.dashboard') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.dashboard') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">dashboard</i>
                Dashboard
            </a>
        </div>

        <!-- Inventory Management -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75">
                Inventory Management
            </div>
        </div>

        <!-- Items -->
        @can('warehouse.items.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.items.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.items.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">inventory_2</i>
                Items
                @if(request()->routeIs('warehouse.items.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.items.*'))
                <div class="ml-4">
                    @can('warehouse.items.view')
                    <a href="{{ route('warehouse.items.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.items.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Items
                    </a>
                    @endcan
                    @can('warehouse.items.create')
                    <a href="{{ route('warehouse.items.create') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.items.create') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        Add Item
                    </a>
                    @endcan
                    <a href="{{ route('warehouse.items.categories') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.items.categories*') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">category</i>
                        Categories
                    </a>
                    <a href="{{ route('warehouse.items.low-stock') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.items.low-stock') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">warning</i>
                        Low Stock
                    </a>
                </div>
            @endif
        </div>
        @endcan

        <!-- Inventory -->
        @can('warehouse.inventory.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.inventory.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.inventory.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">inventory</i>
                Inventory
                @if(request()->routeIs('warehouse.inventory.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.inventory.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.inventory.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.inventory.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">view_list</i>
                        All Inventory
                    </a>
                    @can('warehouse.inventory.adjust')
                    <a href="{{ route('warehouse.inventory.adjustments') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.inventory.adjustments*') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">tune</i>
                        Adjustments
                    </a>
                    @endcan
                    @can('warehouse.inventory.transfer')
                    <a href="{{ route('warehouse.inventory.transfers') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.inventory.transfers*') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">swap_horiz</i>
                        Transfers
                    </a>
                    @endcan
                    @can('warehouse.inventory.count')
                    <a href="{{ route('warehouse.inventory.physical-count') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.inventory.physical-count*') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">fact_check</i>
                        Physical Count
                    </a>
                    @endcan
                </div>
            @endif
        </div>
        @endcan

        <!-- Transactions -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Transactions
            </div>
        </div>

        <!-- Incoming Operations -->
        @can('warehouse.incoming.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.incoming-operations.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.incoming-operations.*') || request()->routeIs('warehouse.supplier-delivery.*') || request()->routeIs('warehouse.site-return.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon text-success">input</i>
                Incoming Operations
                @if(request()->routeIs('warehouse.incoming-operations.*') || request()->routeIs('warehouse.supplier-delivery.*') || request()->routeIs('warehouse.site-return.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.incoming-operations.*') || request()->routeIs('warehouse.supplier-delivery.*') || request()->routeIs('warehouse.site-return.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.incoming-operations.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.incoming-operations.index') && !request()->has('type') && !request()->has('operation_type') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">dashboard</i>
                        Dashboard
                    </a>
                    <a href="{{ route('warehouse.supplier-delivery.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.supplier-delivery.*') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon text-primary" style="font-size: 16px;">local_shipping</i>
                        Supplier Deliveries
                    </a>
                    <a href="{{ route('warehouse.site-return.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.site-return.*') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">assignment_return</i>
                        Site Returns
                    </a>
                </div>
            @endif
        </div>
        @endcan

        <!-- Outgoing -->
        @can('warehouse.outgoing.view')
        <div class="mb-1">
            <a href="#" onclick="toggleOutgoingMenu(); return false;"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.outgoing.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon text-primary">output</i>
                Outgoing
                <i class="material-icons ml-auto" id="outgoing-menu-icon" style="font-size: 16px;">
                    {{ request()->routeIs('warehouse.outgoing.*') ? 'expand_more' : 'chevron_right' }}
                </i>
            </a>
            <div class="ml-4" id="outgoing-submenu" style="display: {{ request()->routeIs('warehouse.outgoing.*') ? 'block' : 'none' }};">
                <a href="{{ route('warehouse.outgoing.index') }}"
                   class="warehouse-nav-link small {{ request()->routeIs('warehouse.outgoing.index') ? 'active' : '' }}">
                    <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                    Material Issues
                </a>
                @can('warehouse.outgoing.create')
                <a href="{{ route('warehouse.outgoing.create') }}"
                   class="warehouse-nav-link small {{ request()->routeIs('warehouse.outgoing.create') ? 'active' : '' }}">
                    <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                    New Material Issue
                </a>
                @endcan
                <a href="{{ route('warehouse.outgoing.pending-approval') }}"
                   class="warehouse-nav-link small {{ request()->routeIs('warehouse.outgoing.pending-approval') ? 'active' : '' }}">
                    <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">approval</i>
                    Pending Approval
                </a>

            </div>
        </div>
        @endcan

        <!-- Returns -->
        @can('warehouse.returns.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.returns.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.returns.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon text-info">keyboard_return</i>
                Returns
                @if(request()->routeIs('warehouse.returns.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.returns.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.returns.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.returns.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Returns
                    </a>
                    @can('warehouse.returns.create')
                    <a href="{{ route('warehouse.returns.create') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.returns.create') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        New Return
                    </a>
                    @endcan
                </div>
            @endif
        </div>
        @endcan

        <!-- Projects & Suppliers -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Management
            </div>
        </div>

        <!-- Projects -->
        @can('warehouse.projects.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.projects.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.projects.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">work</i>
                Projects
            </a>
        </div>
        @endcan

        <!-- Suppliers -->
        @can('warehouse.suppliers.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.suppliers.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.suppliers.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">business</i>
                Suppliers
                @if(request()->routeIs('warehouse.suppliers.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.suppliers.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.suppliers.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.suppliers.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Suppliers
                    </a>
                    @can('warehouse.suppliers.create')
                    <a href="{{ route('warehouse.suppliers.create') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.suppliers.create') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        Add Supplier
                    </a>
                    @endcan
                    <a href="{{ route('warehouse.suppliers.index') }}?filter=top_rated"
                       class="warehouse-nav-link small {{ request()->get('filter') == 'top_rated' ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">star</i>
                        Top Rated
                    </a>
                    <a href="{{ route('warehouse.suppliers.index') }}?filter=performance"
                       class="warehouse-nav-link small {{ request()->get('filter') == 'performance' ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon text-success" style="font-size: 16px;">trending_up</i>
                        Performance
                    </a>
                </div>
            @endif
        </div>
        @endcan

        <!-- Locations -->
        @can('warehouse.locations.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.locations.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.locations.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">place</i>
                Locations
                @if(request()->routeIs('warehouse.locations.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.locations.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.locations.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.locations.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Locations
                    </a>
                    @can('warehouse.locations.create')
                    <a href="{{ route('warehouse.locations.create') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.locations.create') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">add</i>
                        Add Location
                    </a>
                    @endcan
                </div>
            @endif
        </div>
        @endcan

        <!-- Reports -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Reports
            </div>
        </div>

        <!-- Reports -->
        @can('warehouse.reports.view')
        <div class="mb-1">
            <li class="sidebar-menu-item {{ request()->routeIs('warehouse.reports.*') ? 'open' : '' }}">
                <a class="sidebar-menu-button warehouse-nav-link" data-toggle="collapse" href="#reports_menu" aria-expanded="{{ request()->routeIs('warehouse.reports.*') ? 'true' : 'false' }}">
                    <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons warehouse-nav-icon">assessment</i>
                    <span class="sidebar-menu-text">Reports</span>
                    <i class="material-icons ml-auto sidebar-menu-toggle-icon">{{ request()->routeIs('warehouse.reports.*') ? 'keyboard_arrow_down' : 'keyboard_arrow_right' }}</i>
                </a>
                <ul class="sidebar-submenu collapse {{ request()->routeIs('warehouse.reports.*') ? 'show' : '' }}" id="reports_menu">
                    <li class="sidebar-menu-item {{ request()->routeIs('warehouse.reports.inventory') ? 'active' : '' }}">
                        <a class="sidebar-menu-button warehouse-nav-link small" href="{{ route('warehouse.reports.inventory') }}">
                            <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">inventory</i>
                            <span class="sidebar-menu-text ml-3">Inventory Report</span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item {{ request()->routeIs('warehouse.reports.incoming') ? 'active' : '' }}">
                        <a class="sidebar-menu-button warehouse-nav-link small" href="{{ route('warehouse.reports.incoming') }}">
                            <i class="material-icons warehouse-nav-icon text-success" style="font-size: 16px;">input</i>
                            <span class="sidebar-menu-text ml-3">Incoming Materials Report</span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item {{ request()->routeIs('warehouse.reports.returns') ? 'active' : '' }}">
                        <a class="sidebar-menu-button warehouse-nav-link small" href="{{ route('warehouse.reports.returns') }}">
                            <i class="material-icons warehouse-nav-icon text-warning" style="font-size: 16px;">keyboard_return</i>
                            <span class="sidebar-menu-text ml-3">Returns Goods Report</span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item {{ request()->routeIs('warehouse.reports.outgoing') ? 'active' : '' }}">
                        <a class="sidebar-menu-button warehouse-nav-link small" href="{{ route('warehouse.reports.outgoing') }}">
                            <i class="material-icons warehouse-nav-icon text-primary" style="font-size: 16px;">output</i>
                            <span class="sidebar-menu-text ml-3">Outgoing Material Report</span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item {{ request()->routeIs('warehouse.reports.transactions') ? 'active' : '' }}">
                        <a class="sidebar-menu-button warehouse-nav-link small" href="{{ route('warehouse.reports.transactions') }}">
                            <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">receipt</i>
                            <span class="sidebar-menu-text ml-3">Transaction Report</span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item {{ request()->routeIs('warehouse.reports.project-transfers') ? 'active' : '' }}">
                        <a class="sidebar-menu-button warehouse-nav-link small" href="{{ route('warehouse.reports.project-transfers') }}">
                            <i class="material-icons warehouse-nav-icon text-info" style="font-size: 16px;">swap_horiz</i>
                            <span class="sidebar-menu-text ml-3">Project to Project Transfer Report</span>
                        </a>
                    </li>
                    <li class="sidebar-menu-item {{ request()->routeIs('warehouse.reports.direct-deliveries') ? 'active' : '' }}">
                        <a class="sidebar-menu-button warehouse-nav-link small" href="{{ route('warehouse.reports.direct-deliveries') }}">
                            <i class="material-icons warehouse-nav-icon text-success" style="font-size: 16px;">local_shipping</i>
                            <span class="sidebar-menu-text ml-3">Supplier Direct Delivery Report</span>
                        </a>
                    </li>
                </ul>
            </li>
        </div>
        @endcan


        <!-- Settings -->
        <div class="mb-1">
            <div class="text-light px-3 py-2 small font-weight-semibold text-uppercase opacity-75 mt-3">
                Settings
            </div>
        </div>

        <!-- Warehouse Settings -->
        @can('warehouse.settings.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.settings.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.settings.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">settings</i>
                Settings
            </a>
        </div>
        @endcan

        <!-- User Management -->
        @can('warehouse.users.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.users.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.users.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">people</i>
                User Management
                @if(request()->routeIs('warehouse.users.*'))
                    <i class="material-icons ml-auto" style="font-size: 16px;">expand_more</i>
                @else
                    <i class="material-icons ml-auto" style="font-size: 16px;">chevron_right</i>
                @endif
            </a>
            @if(request()->routeIs('warehouse.users.*'))
                <div class="ml-4">
                    <a href="{{ route('warehouse.users.index') }}"
                       class="warehouse-nav-link small {{ request()->routeIs('warehouse.users.index') ? 'active' : '' }}">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">list</i>
                        All Users
                    </a>
                    @can('warehouse.users.create')
                    <a href="{{ route('warehouse.users.index') }}#add-user"
                       class="warehouse-nav-link small">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">person_add</i>
                        Add User
                    </a>
                    @endcan
                    @can('warehouse.users.roles')
                    <a href="{{ route('warehouse.users.index') }}?view=roles"
                       class="warehouse-nav-link small">
                        <i class="material-icons warehouse-nav-icon" style="font-size: 16px;">admin_panel_settings</i>
                        User Roles
                    </a>
                    @endcan
                </div>
            @endif
        </div>
        @endcan

        <!-- Activity Log -->
        @can('warehouse.activity-log.view')
        <div class="mb-1">
            <a href="{{ route('warehouse.activity-log.index') }}"
               class="warehouse-nav-link {{ request()->routeIs('warehouse.activity-log.*') ? 'active' : '' }}">
                <i class="material-icons warehouse-nav-icon">history</i>
                Activity Log
            </a>
        </div>
        @endcan
    </div>

    <!-- Quick Stats Footer -->
    <div class="mt-auto p-3 border-top border-secondary">
        <div class="text-light small mb-2 opacity-75">Quick Stats</div>
        <div class="d-flex justify-content-between text-light small">
            <div>
                <div class="font-weight-semibold">Items</div>
                <div id="quick-stats-items" class="text-warning">-</div>
            </div>
            <div class="text-center">
                <div class="font-weight-semibold">Low Stock</div>
                <div id="quick-stats-low-stock" class="text-danger">-</div>
            </div>
            <div class="text-right">
                <div class="font-weight-semibold">Pending</div>
                <div id="quick-stats-pending" class="text-info">-</div>
            </div>
        </div>
    </div>
</aside>

<script>
// Load quick stats
document.addEventListener('DOMContentLoaded', function() {
    fetch('/warehouse/api/quick-stats')
        .then(response => response.json())
        .then(data => {
            document.getElementById('quick-stats-items').textContent = data.total_items || '0';
            document.getElementById('quick-stats-low-stock').textContent = data.low_stock_items || '0';
            document.getElementById('quick-stats-pending').textContent = data.pending_transactions || '0';
        })
        .catch(error => {
            console.error('Error loading quick stats:', error);
        });
});

// Toggle Outgoing Menu
function toggleOutgoingMenu() {
    const submenu = document.getElementById('outgoing-submenu');
    const icon = document.getElementById('outgoing-menu-icon');

    if (submenu.style.display === 'none') {
        submenu.style.display = 'block';
        icon.textContent = 'expand_more';
    } else {
        submenu.style.display = 'none';
        icon.textContent = 'chevron_right';
    }
}

</script>