<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Goods Received Note - {{ $operation->operation_number }}</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; color: #333; }
        .header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 20px; margin-bottom: 30px; }
        .company-info { text-align: center; margin-bottom: 20px; }
        .document-title { font-size: 24px; font-weight: bold; margin: 20px 0; }
        .info-section { margin-bottom: 25px; }
        .info-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .info-block { }
        .info-label { font-weight: bold; display: inline-block; width: 120px; }
        .items-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        .items-table th, .items-table td { border: 1px solid #333; padding: 8px; text-align: left; }
        .items-table th { background-color: #f5f5f5; font-weight: bold; }
        .totals { margin-top: 20px; text-align: right; }
        .signatures { margin-top: 40px; }
        .signature-block { display: inline-block; width: 200px; margin: 0 20px; text-align: center; }
        .signature-line { border-bottom: 1px solid #333; height: 50px; margin-bottom: 10px; }
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-info">
            <h1>{{ config('app.name', 'KCG Inventory') }}</h1>
            <p>Warehouse Management System</p>
        </div>
        <div class="document-title">GOODS RECEIVED NOTE</div>
    </div>

    <div class="info-section">
        <div class="info-grid">
            <div class="info-block">
                <p><span class="info-label">GRN Number:</span> {{ $operation->operation_number }}</p>
                <p><span class="info-label">Date:</span> {{ $operation->operation_date->format('d/m/Y') }}</p>
                <p><span class="info-label">Operation Type:</span> {{ $operation->operation_type_label }}</p>
                <p><span class="info-label">Status:</span> {{ ucfirst($operation->status) }}</p>
                @if($operation->lpo_number)
                <p><span class="info-label">LPO Number:</span> {{ $operation->lpo_number }}</p>
                @endif
                @if($operation->delivery_note_number)
                <p><span class="info-label">Delivery Note:</span> {{ $operation->delivery_note_number }}</p>
                @endif
            </div>

            <div class="info-block">
                @if($operation->supplier)
                <p><span class="info-label">Supplier:</span> {{ $operation->supplier->name }}</p>
                @endif
                <p><span class="info-label">Division:</span> {{ $operation->division }}</p>
                <p><span class="info-label">Currency:</span> {{ $operation->currency }}</p>
                <p><span class="info-label">Exchange Rate:</span> {{ number_format($operation->exchange_rate, 4) }}</p>
                <p><span class="info-label">Received By:</span> {{ $operation->received_by_name ?: ($operation->receiver->name ?? 'N/A') }}</p>
            </div>
        </div>
    </div>

    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 5%;">#</th>
                <th style="width: 25%;">Item Description</th>
                <th style="width: 15%;">Item Code</th>
                <th style="width: 10%;">Quantity</th>
                <th style="width: 10%;">Unit</th>
                <th style="width: 12%;">Unit Price</th>
                <th style="width: 12%;">Total Price</th>
                <th style="width: 11%;">Batch/Serial</th>
            </tr>
        </thead>
        <tbody>
            @forelse($operation->items as $index => $item)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $item->item->item_description ?? 'Unknown Item' }}</td>
                <td>{{ $item->item->item_code ?? 'NO-CODE' }}</td>
                <td>{{ number_format($item->quantity_delivered, 2) }}</td>
                <td>{{ $item->item->unit_of_measure ?? 'units' }}</td>
                <td>{{ $item->currency }} {{ number_format($item->unit_price, 2) }}</td>
                <td>{{ $item->currency }} {{ number_format($item->total_price, 2) }}</td>
                <td>{{ $item->batch_number ?: '-' }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="8" style="text-align: center;">No items found</td>
            </tr>
            @endforelse
        </tbody>
    </table>

    <div class="totals">
        <p><strong>Total Amount: {{ $operation->formatted_total_amount }}</strong></p>
        @if($operation->currency !== 'AED')
        <p><strong>Total Amount (AED): {{ $operation->formatted_total_amount_aed }}</strong></p>
        @endif
        @if($operation->vat_amount > 0)
        <p>VAT ({{ $operation->vat_rate }}%): AED {{ number_format($operation->vat_amount, 2) }}</p>
        @endif
    </div>

    @if($operation->notes)
    <div class="info-section">
        <p><strong>Notes:</strong></p>
        <p>{{ $operation->notes }}</p>
    </div>
    @endif

    <div class="signatures">
        <div class="signature-block">
            <div class="signature-line"></div>
            <p><strong>Received By</strong><br>
            {{ $operation->received_by_name ?: ($operation->receiver->name ?? '') }}<br>
            Date: {{ $operation->created_at->format('d/m/Y') }}</p>
        </div>

        @if($operation->inspector)
        <div class="signature-block">
            <div class="signature-line"></div>
            <p><strong>Inspected By</strong><br>
            {{ $operation->inspector->name }}<br>
            Date: {{ $operation->inspection_datetime ? $operation->inspection_datetime->format('d/m/Y') : '___________' }}</p>
        </div>
        @endif

        @if($operation->approver)
        <div class="signature-block">
            <div class="signature-line"></div>
            <p><strong>Approved By</strong><br>
            {{ $operation->approver->name }}<br>
            Date: {{ $operation->approved_at ? $operation->approved_at->format('d/m/Y') : '___________' }}</p>
        </div>
        @endif
    </div>

    <div class="no-print" style="margin-top: 30px; text-align: center;">
        <button onclick="window.print()" style="padding: 10px 20px; font-size: 16px;">Print Document</button>
        <button onclick="window.close()" style="padding: 10px 20px; font-size: 16px; margin-left: 10px;">Close</button>
    </div>
</body>
</html>