@extends('layouts.admin-simple')

@section('title', 'Edit Project')
@section('page-title', 'Edit Project')
@section('page-subtitle', 'Update project information')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.projects.index') }}">Projects</a></li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.projects.show', $project) }}">{{ $project->project_name }}</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
    <div class="max-w-2xl mx-auto">
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900">Edit Project Information</h3>
            </div>

            <form action="{{ route('warehouse.projects.update', $project) }}" method="POST" class="p-6">
                @csrf
                @method('PUT')

                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Project Number</label>
                    <input type="text" name="project_number" value="{{ old('project_number', $project->project_number) }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('project_number') border-red-500 @enderror"
                           placeholder="Enter project number">
                    @error('project_number')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Project Name *</label>
                    <input type="text" name="project_name" value="{{ old('project_name', $project->project_name) }}" required
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('project_name') border-red-500 @enderror"
                           placeholder="Enter project name">
                    @error('project_name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Project Division <span class="text-red-500">*</span></label>
                    <select name="project_division_id"
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('project_division_id') border-red-500 @enderror"
                            required>
                        <option value="">Select a division</option>
                        @foreach($divisions as $division)
                            <option value="{{ $division->id }}" {{ old('project_division_id', $project->project_division_id) == $division->id ? 'selected' : '' }}>
                                {{ $division->division_name }} ({{ $division->division_code }})
                            </option>
                        @endforeach
                    </select>
                    @error('project_division_id')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex justify-end space-x-3 pt-6 border-t border-gray-200">
                    <a href="{{ route('warehouse.projects.show', $project) }}"
                       class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        Cancel
                    </a>
                    <button type="submit"
                            class="inline-flex items-center px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        Update Project
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection