@extends('layouts.admin-simple')

@section('title', $project->project_name)
@section('page-title', $project->project_name)
@section('page-subtitle', 'Project Details')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.projects.index') }}">Projects</a></li>
    <li class="breadcrumb-item active">{{ $project->project_name }}</li>
@endsection

@section('page-actions')
    <div class="flex space-x-2">
        @can('warehouse.projects.edit')
        <a href="{{ route('warehouse.projects.edit', $project) }}"
           class="inline-flex items-center px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
            </svg>
            Edit Project
        </a>
        @endcan
    </div>
@endsection

@section('content')
    <!-- Project Information -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">Project Information</h3>
        </div>

        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <h4 class="text-sm font-medium text-gray-900 mb-3">Basic Information</h4>
                    <dl class="space-y-2">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Project Number</dt>
                            <dd class="text-sm text-gray-900">{{ $project->project_number ?: 'Not set' }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Project ID</dt>
                            <dd class="text-sm text-gray-900">{{ $project->project_id ?: 'Not synced' }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Project Name</dt>
                            <dd class="text-sm text-gray-900">{{ $project->project_name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Project Division</dt>
                            <dd class="text-sm text-gray-900">
                                @if($project->projectDivision)
                                    {{ $project->projectDivision->division_name }} ({{ $project->projectDivision->division_code }})
                                @else
                                    Not assigned
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Created Date</dt>
                            <dd class="text-sm text-gray-900">{{ $project->created_at->format('M d, Y H:i') }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Last Updated</dt>
                            <dd class="text-sm text-gray-900">{{ $project->updated_at->format('M d, Y H:i') }}</dd>
                        </div>
                    </dl>
                </div>
            </div>
        </div>
    </div>
@endsection