@extends('layouts.admin-simple')

@section('title', 'Outgoing Item Details - ' . $itemDetails->item_code)

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.outgoing') }}">Outgoing Materials</a></li>
    <li class="breadcrumb-item active">{{ $itemDetails->item_code }}</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">{{ $itemDetails->item_code }} - Material Request Details</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">{{ $itemDetails->item_description }}</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.reports.outgoing') }}" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Report
            </a>
            <button type="button" onclick="printItemDetails()" class="btn btn-sm btn-info">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print Details
            </button>
        </div>
    </div>
@endsection

@section('content')
    <!-- Transaction Summary ---->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">assignment</i>
                Transaction Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Material Request #:</strong></td>
                            <td><span class="badge badge-primary">{{ $transactionDetails->material_request_number }}</span></td>
                        </tr>
                        <tr>
                            <td><strong>Transaction Date:</strong></td>
                            <td>{{ $transactionDetails->transaction_date ? $transactionDetails->transaction_date->format('d M, Y') : '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td>
                                <span class="badge badge-{{
                                    $transactionDetails->status === 'completed' ? 'success' :
                                    ($transactionDetails->status === 'partially_fulfilled' ? 'warning' :
                                    ($transactionDetails->status === 'approved' ? 'info' : 'secondary'))
                                }}">
                                    {{ ucfirst(str_replace('_', ' ', $transactionDetails->status)) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Project:</strong></td>
                            <td>
                                <div>{{ $transactionDetails->project_name }}</div>
                                <small class="text-muted">ID: {{ $transactionDetails->project_code }}</small>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Division:</strong></td>
                            <td><span class="badge badge-light">{{ $transactionDetails->division_name }}</span></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Requester:</strong></td>
                            <td>{{ $transactionDetails->requester_name }}</td>
                        </tr>
                        <tr>
                            <td><strong>Receiver:</strong></td>
                            <td>{{ $transactionDetails->receiver_name ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Delivery Location:</strong></td>
                            <td>{{ $transactionDetails->delivery_location ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Purpose:</strong></td>
                            <td>{{ $transactionDetails->purpose ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Created:</strong></td>
                            <td>{{ $transactionDetails->created_at ? $transactionDetails->created_at->format('d M, Y H:i') : '-' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
            @if($transactionDetails->remarks)
                <div class="row mt-3">
                    <div class="col-12">
                        <strong>Remarks:</strong>
                        <div class="mt-1 p-2 bg-light rounded">
                            {{ $transactionDetails->remarks }}
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Item Details -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">inventory_2</i>
                Item Details & Quantities
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Item Code:</strong></td>
                            <td><code>{{ $itemDetails->item_code }}</code></td>
                        </tr>
                        <tr>
                            <td><strong>Description:</strong></td>
                            <td>{{ $itemDetails->item_description }}</td>
                        </tr>
                        <tr>
                            <td><strong>Category:</strong></td>
                            <td><span class="badge badge-outline-primary">{{ $itemDetails->category_name }}</span></td>
                        </tr>
                        <tr>
                            <td><strong>Unit of Measure:</strong></td>
                            <td>{{ $itemDetails->unit_of_measure }}</td>
                        </tr>
                        <tr>
                            <td><strong>Batch Number:</strong></td>
                            <td>{{ $itemDetails->batch_number ?: '-' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Quantity Requested:</strong></td>
                            <td><strong class="text-primary">{{ number_format($itemDetails->quantity_requested, 2) }} {{ $itemDetails->unit_of_measure }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Quantity Released:</strong></td>
                            <td><strong class="text-success">{{ number_format($itemDetails->quantity_released, 2) }} {{ $itemDetails->unit_of_measure }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Balance Pending:</strong></td>
                            <td>
                                <strong class="{{ $itemDetails->quantity_balance > 0 ? 'text-warning' : 'text-success' }}">
                                    {{ number_format($itemDetails->quantity_balance, 2) }} {{ $itemDetails->unit_of_measure }}
                                </strong>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Unit Price:</strong></td>
                            <td>{{ $itemDetails->unit_price ? 'AED ' . number_format($itemDetails->unit_price, 2) : '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Total Price:</strong></td>
                            <td>{{ $itemDetails->total_price ? 'AED ' . number_format($itemDetails->total_price, 2) : '-' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Fulfillment Status -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">track_changes</i>
                        Fulfillment Status
                    </h6>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="mr-3">
                            <span class="badge badge-lg badge-{{
                                $itemDetails->fulfillment_status === 'completed' ? 'success' :
                                ($itemDetails->fulfillment_status === 'partial' ? 'warning' : 'secondary')
                            }}">
                                {{ ucfirst($itemDetails->fulfillment_status) }}
                            </span>
                        </div>
                        <div>
                            @if($itemDetails->fulfillment_status === 'completed')
                                <div class="text-success">✓ Fully fulfilled</div>
                            @elseif($itemDetails->fulfillment_status === 'partial')
                                <div class="text-warning">⚠ Partially fulfilled</div>
                            @else
                                <div class="text-secondary">○ Pending fulfillment</div>
                            @endif
                        </div>
                    </div>

                    <!-- Progress bar -->
                    @php
                        $fulfillmentPercentage = $itemDetails->quantity_requested > 0 ?
                            ($itemDetails->quantity_released / $itemDetails->quantity_requested) * 100 : 0;
                    @endphp
                    <div class="progress mb-3" style="height: 20px;">
                        <div class="progress-bar bg-{{
                            $fulfillmentPercentage >= 100 ? 'success' :
                            ($fulfillmentPercentage > 0 ? 'warning' : 'secondary')
                        }}"
                        role="progressbar"
                        style="width: {{ min($fulfillmentPercentage, 100) }}%"
                        aria-valuenow="{{ $fulfillmentPercentage }}"
                        aria-valuemin="0"
                        aria-valuemax="100">
                            {{ round($fulfillmentPercentage, 1) }}%
                        </div>
                    </div>

                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Release Date:</span>
                            <span>{{ $itemDetails->release_date ? $itemDetails->release_date->format('d M, Y') : 'Not released' }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Last Updated:</span>
                            <span>{{ $itemDetails->updated_at ? $itemDetails->updated_at->format('d M, Y H:i') : '-' }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">notes</i>
                        Additional Information
                    </h6>
                </div>
                <div class="card-body">
                    @if($itemDetails->notes)
                        <div class="mb-3">
                            <strong>Notes:</strong>
                            <div class="mt-1 p-2 bg-light rounded">
                                {{ $itemDetails->notes }}
                            </div>
                        </div>
                    @else
                        <div class="text-center text-muted py-3">
                            <i class="material-icons mb-2" style="font-size: 48px;">note_add</i>
                            <p>No additional notes available</p>
                        </div>
                    @endif

                    <div class="mt-3">
                        <small class="text-muted">
                            <strong>Record ID:</strong> {{ $itemDetails->id }}<br>
                            <strong>Transaction ID:</strong> {{ $transactionDetails->id }}
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .table-borderless td {
            border: none;
            padding: 0.25rem 0.5rem;
        }

        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
        }

        .table td {
            font-size: 13px;
            vertical-align: middle;
        }

        .list-group-item {
            border-left: none;
            border-right: none;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }

        .badge-lg {
            padding: 0.5rem 0.75rem;
            font-size: 14px;
        }

        .progress {
            background-color: #e9ecef;
        }

        .progress-bar {
            font-size: 12px;
            line-height: 20px;
        }
    </style>
@endpush

@push('scripts')
    <script>
        function printItemDetails() {
            window.print();
        }
    </script>
@endpush