@extends('layouts.admin-simple')

@section('title', 'Outgoing Materials Report')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item active">Outgoing Materials</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Outgoing Materials Report</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Material requests and fulfillment tracking</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <button type="button" onclick="exportReport()" class="btn btn-sm btn-success mr-2" title="Export to Excel">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>
            <button type="button" onclick="printReport()" class="btn btn-sm btn-info" title="Print Report">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print
            </button>
        </div>
    </div>
@endsection

@section('content')
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Requests"
                :value="$outgoingRequests->count()"
                icon="assignment"
                color="primary"
                subtitle="All material requests"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Requested"
                :value="$outgoingRequests->sum('total_requested')"
                icon="inventory_2"
                color="info"
                subtitle="Total quantity requested"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Released"
                :value="$outgoingRequests->sum('total_released')"
                icon="outbound"
                color="success"
                subtitle="Total quantity released"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Pending Balance"
                :value="$outgoingRequests->sum('total_balance')"
                icon="pending_actions"
                color="warning"
                subtitle="Total quantity pending"
            />
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('warehouse.reports.outgoing') }}">
                <div class="row">
                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="{{ request('search') }}" class="form-control" placeholder="Item code, description, or MR number">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Project</label>
                        <select name="project_id" class="form-control">
                            <option value="">All Projects</option>
                            @foreach($projects as $project)
                                <option value="{{ $project->id }}" {{ request('project_id') == $project->id ? 'selected' : '' }}>
                                    {{ $project->project_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Division</label>
                        <select name="division_id" class="form-control">
                            <option value="">All Divisions</option>
                            @foreach($divisions as $division)
                                <option value="{{ $division->id }}" {{ request('division_id') == $division->id ? 'selected' : '' }}>
                                    {{ $division->division_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Category</label>
                        <select name="category_id" class="form-control">
                            <option value="">All Categories</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                                    {{ $category->category_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-control">
                            <option value="">All Statuses</option>
                            @foreach($statuses as $status)
                                <option value="{{ $status }}" {{ request('status') == $status ? 'selected' : '' }}>
                                    {{ ucfirst(str_replace('_', ' ', $status)) }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Fulfillment</label>
                        <select name="fulfillment_status" class="form-control">
                            <option value="">All Fulfillment</option>
                            @foreach($fulfillmentStatuses as $fulfillmentStatus)
                                <option value="{{ $fulfillmentStatus }}" {{ request('fulfillment_status') == $fulfillmentStatus ? 'selected' : '' }}>
                                    {{ ucfirst($fulfillmentStatus) }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="{{ request('date_from') }}" class="form-control">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="{{ request('date_to') }}" class="form-control">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3 d-flex align-items-end">
                        <div class="w-100">
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                                Apply Filters
                            </button>
                        </div>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3 d-flex align-items-end">
                        <div class="w-100">
                            <a href="{{ route('warehouse.reports.outgoing') }}" class="btn btn-outline-secondary btn-block">
                                <i class="material-icons mr-1" style="font-size: 16px;">clear</i>
                                Clear Filters
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Outgoing Materials Report Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">assignment_turned_in</i>
                Outgoing Materials Report ({{ $outgoingRequests->count() }} requests)
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Request #</th>
                            <th>Request Date</th>
                            <th>Project</th>
                            <th>Division</th>
                            <th>Requested By</th>
                            <th>Items Count</th>
                            <th>Total Requested</th>
                            <th>Total Released</th>
                            <th>Balance</th>
                            <th>Dispatch Status</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($outgoingRequests as $request)
                            <tr>
                                <td>
                                    <div class="font-weight-medium text-primary">{{ $request->material_request_number ?: 'MR-' . str_pad($request->id, 6, '0', STR_PAD_LEFT) }}</div>
                                </td>
                                <td>
                                    {{ $request->transaction_date->format('d-M-Y') }}
                                </td>
                                <td>
                                    <div class="font-weight-medium">{{ $request->project->project_name ?? 'N/A' }}</div>
                                    <div class="text-muted small">ID: {{ $request->project->id ?? 'N/A' }}</div>
                                </td>
                                <td>
                                    <span class="badge badge-outline-secondary">{{ $request->division->name ?? 'Main' }}</span>
                                </td>
                                <td>
                                    {{ $request->requester->name ?? 'N/A' }}
                                </td>
                                <td class="text-center">
                                    <span class="badge badge-light">{{ $request->items_count }} items</span>
                                </td>
                                <td class="text-right">
                                    <strong>{{ number_format($request->total_requested, 2) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong class="text-success">{{ number_format($request->total_released, 2) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong class="{{ $request->total_balance > 0 ? 'text-warning' : 'text-success' }}">
                                        {{ number_format($request->total_balance, 2) }}
                                    </strong>
                                </td>
                                <td>
                                    @if($request->total_balance == 0)
                                        <span class="badge badge-success">Fully Dispatched</span>
                                    @elseif($request->total_released == 0)
                                        <span class="badge badge-warning">Pending</span>
                                    @else
                                        <span class="badge badge-info">Partially Dispatched</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <a href="{{ route('warehouse.reports.outgoing.request-details', $request->id) }}" class="btn btn-sm btn-outline-primary" title="View request details and dispatch methods">
                                        <i class="material-icons" style="font-size: 16px;">visibility</i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="11" class="text-center py-4">
                                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">assignment</i>
                                    <h5 class="text-muted">No Material Requests Found</h5>
                                    <p class="text-muted mb-0">No requests match your current filters.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        .badge-outline-secondary {
            color: #6c757d;
            border: 1px solid #6c757d;
            background-color: transparent;
        }

        .badge-outline-info {
            color: #17a2b8;
            border: 1px solid #17a2b8;
            background-color: transparent;
        }

        .badge-outline-success {
            color: #28a745;
            border: 1px solid #28a745;
            background-color: transparent;
        }

        .badge-outline-warning {
            color: #ffc107;
            border: 1px solid #ffc107;
            background-color: transparent;
        }

        .badge-outline-danger {
            color: #dc3545;
            border: 1px solid #dc3545;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
            white-space: nowrap;
        }

        .table td {
            vertical-align: middle;
            font-size: 13px;
        }

        .badge {
            font-size: 10px;
            padding: 3px 6px;
        }

        .small {
            font-size: 11px;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }
    </style>
@endpush

@push('scripts')
    <script>
        function exportReport() {
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Exporting...';
            btn.disabled = true;

            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.disabled = false;
                alert('Export functionality will be implemented');
            }, 1000);
        }

        function printReport() {
            window.print();
        }
    </script>
@endpush