@extends('layouts.admin-simple')

@section('title', 'Return Goods Report')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item active">Return Goods</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Return Goods Report</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Site returns and material return tracking</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <button type="button" onclick="exportReport()" class="btn btn-sm btn-success mr-2" title="Export to Excel">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>
            <button type="button" onclick="printReport()" class="btn btn-sm btn-info" title="Print Report">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print
            </button>
        </div>
    </div>
@endsection

@section('content')
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Returns"
                :value="$returnItems->count()"
                icon="assignment_return"
                color="warning"
                subtitle="All returned items"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Quantity"
                :value="number_format($returnItems->sum('quantity'), 2)"
                icon="inventory_2"
                color="info"
                subtitle="Total quantity returned"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Value"
                :value="'AED ' . number_format($returnItems->sum('total_price'), 2)"
                icon="attach_money"
                color="danger"
                subtitle="Total value of returns"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Quality Passed"
                :value="$returnItems->where('quality_status', 'passed')->count()"
                icon="verified"
                color="success"
                subtitle="Items passed quality check"
            />
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('warehouse.reports.returns') }}">
                <div class="row">
                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="{{ request('search') }}" class="form-control" placeholder="Item code, description, or return number">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Project</label>
                        <select name="project_id" class="form-control">
                            <option value="">All Projects</option>
                            @foreach($projects as $project)
                                <option value="{{ $project->id }}" {{ request('project_id') == $project->id ? 'selected' : '' }}>
                                    {{ $project->project_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Division</label>
                        <select name="division_id" class="form-control">
                            <option value="">All Divisions</option>
                            @foreach($divisions as $division)
                                <option value="{{ $division->id }}" {{ request('division_id') == $division->id ? 'selected' : '' }}>
                                    {{ $division->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Category</label>
                        <select name="category_id" class="form-control">
                            <option value="">All Categories</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                                    {{ $category->category_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Quality Status</label>
                        <select name="quality_status" class="form-control">
                            <option value="">All Quality Status</option>
                            @foreach($qualityStatuses as $status)
                                <option value="{{ $status }}" {{ request('quality_status') == $status ? 'selected' : '' }}>
                                    {{ ucfirst($status) }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="{{ request('date_from') }}" class="form-control">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="{{ request('date_to') }}" class="form-control">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3 d-flex align-items-end">
                        <div class="w-100">
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                                Apply Filters
                            </button>
                        </div>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3 d-flex align-items-end">
                        <div class="w-100">
                            <a href="{{ route('warehouse.reports.returns') }}" class="btn btn-outline-secondary btn-block">
                                <i class="material-icons mr-1" style="font-size: 16px;">clear</i>
                                Clear Filters
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Return Goods Report Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">assignment_return</i>
                Return Goods Report ({{ $returnItems->count() }} items)
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Project Name</th>
                            <th>Project Number</th>
                            <th>Division</th>
                            <th>Type of Goods</th>
                            <th>Item Code</th>
                            <th>Item Description</th>
                            <th>Unit</th>
                            <th>Quantity</th>
                            <th>Unit Price</th>
                            <th>Total Price</th>
                            <th>Production Date</th>
                            <th>Expiry Date</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($returnItems as $item)
                            <tr>
                                <td>
                                    <div class="font-weight-medium">{{ $item->project_name }}</div>
                                </td>
                                <td>
                                    <span class="badge badge-outline-info">{{ $item->project_number }}</span>
                                </td>
                                <td>
                                    <span class="badge badge-outline-secondary">{{ $item->division }}</span>
                                </td>
                                <td>
                                    <span class="badge badge-outline-primary">{{ $item->type_of_goods }}</span>
                                </td>
                                <td>
                                    <code>{{ $item->item_code }}</code>
                                </td>
                                <td>
                                    <div>{{ $item->item_description }}</div>
                                </td>
                                <td class="text-center">{{ $item->unit }}</td>
                                <td class="text-right">
                                    <strong>{{ number_format($item->quantity, 2) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong>AED {{ number_format($item->unit_price, 2) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong class="text-danger">AED {{ number_format($item->total_price, 2) }}</strong>
                                </td>
                                <td class="text-center">
                                    {{ $item->production_date ? $item->production_date->format('d M, Y') : '-' }}
                                </td>
                                <td class="text-center">
                                    @if($item->expiry_date)
                                        <span class="{{ $item->expiry_date < now() ? 'text-danger' : ($item->expiry_date < now()->addDays(30) ? 'text-warning' : 'text-success') }}">
                                            {{ $item->expiry_date->format('d M, Y') }}
                                        </span>
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="text-center">
                                    <a href="{{ route('warehouse.reports.returns.item-details', $item->id) }}" class="btn btn-sm btn-outline-primary" title="View detailed information">
                                        <i class="material-icons" style="font-size: 16px;">visibility</i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="13" class="text-center py-4">
                                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">assignment_return</i>
                                    <h5 class="text-muted">No Return Goods Found</h5>
                                    <p class="text-muted mb-0">No returns match your current filters.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        .badge-outline-secondary {
            color: #6c757d;
            border: 1px solid #6c757d;
            background-color: transparent;
        }

        .badge-outline-info {
            color: #17a2b8;
            border: 1px solid #17a2b8;
            background-color: transparent;
        }

        .badge-outline-success {
            color: #28a745;
            border: 1px solid #28a745;
            background-color: transparent;
        }

        .badge-outline-warning {
            color: #ffc107;
            border: 1px solid #ffc107;
            background-color: transparent;
        }

        .badge-outline-danger {
            color: #dc3545;
            border: 1px solid #dc3545;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
            white-space: nowrap;
        }

        .table td {
            vertical-align: middle;
            font-size: 13px;
        }

        .badge {
            font-size: 10px;
            padding: 3px 6px;
        }

        .small {
            font-size: 11px;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }
    </style>
@endpush

@push('scripts')
    <script>
        function exportReport() {
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Exporting...';
            btn.disabled = true;

            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.disabled = false;
                alert('Export functionality will be implemented');
            }, 1000);
        }

        function printReport() {
            window.print();
        }
    </script>
@endpush