@extends('layouts.admin-simple')

@section('title', 'Stock on Project Report')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item">Reports</li>
    <li class="breadcrumb-item active">Stock on Project</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Stock on Project Report</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">View stock levels and inventory distribution across projects</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <button type="button" onclick="exportReport()" class="btn btn-sm btn-success mr-2" title="Export to Excel">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>
            <button type="button" onclick="printReport()" class="btn btn-sm btn-info" title="Print Report">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print
            </button>
        </div>
    </div>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Filters Card -->
    <div class="card mb-3">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">filter_list</i>
                Report Filters
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('warehouse.reports.stock-on-project') }}" id="filterForm">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Search Projects</label>
                            <input type="text" name="search" id="search" class="form-control"
                                   placeholder="Project name, number or description..."
                                   value="{{ request('search') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="project_status">Project Status</label>
                            <select name="project_status" id="project_status" class="form-control">
                                <option value="">All Statuses</option>
                                @foreach($projectStatuses as $status)
                                    <option value="{{ $status }}" {{ request('project_status') == $status ? 'selected' : '' }}>
                                        {{ ucfirst(str_replace('_', ' ', $status)) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="date_from">From Date</label>
                            <input type="date" name="date_from" id="date_from" class="form-control"
                                   value="{{ request('date_from') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="date_to">To Date</label>
                            <input type="date" name="date_to" id="date_to" class="form-control"
                                   value="{{ request('date_to') }}">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                            Generate Report
                        </button>
                        <a href="{{ route('warehouse.reports.stock-on-project') }}" class="btn btn-secondary ml-2">
                            <i class="material-icons mr-1" style="font-size: 16px;">clear</i>
                            Clear Filters
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Report Content -->
    <div class="card">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">business_center</i>
                Stock on Project Report
                @if($projects->count() > 0)
                    <span class="badge badge-primary ml-2">{{ $projects->count() }} Projects</span>
                @endif
            </h6>
        </div>
        <div class="card-body">
            @if($projects->count() > 0)
                <div class="table-responsive">
                    <table class="table table-striped dataTable">
                        <thead>
                            <tr>
                                <th>Project</th>
                                <th>Project Number</th>
                                <th>Status</th>
                                <th class="text-right">Total Items</th>
                                <th class="text-right">Total Stock Qty</th>
                                <th class="text-right">Total Value (AED)</th>
                                <th class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($projects as $project)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="material-icons mr-2" style="color: {{ $project->status === 'active' ? '#28a745' : ($project->status === 'completed' ? '#007bff' : '#6c757d') }}; font-size: 20px;">work</i>
                                            <div>
                                                <div class="font-weight-semibold">{{ $project->project_name }}</div>
                                                @if($project->project_number)
                                                    <small class="text-muted">{{ $project->project_number }}</small>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-light">{{ $project->project_number ?: 'N/A' }}</span>
                                    </td>
                                    <td>
                                        @php
                                            $statusColors = [
                                                'active' => 'success',
                                                'completed' => 'primary',
                                                'on_hold' => 'warning',
                                                'cancelled' => 'danger'
                                            ];
                                            $statusColor = $statusColors[$project->status] ?? 'secondary';
                                        @endphp
                                        <span class="badge badge-{{ $statusColor }}">
                                            {{ ucfirst(str_replace('_', ' ', $project->status)) }}
                                        </span>
                                    </td>
                                    <td class="text-right">
                                        <span class="font-weight-semibold">{{ number_format($project->unique_items) }}</span>
                                    </td>
                                    <td class="text-right">
                                        <span class="font-weight-semibold">{{ number_format($project->total_stock) }}</span>
                                    </td>
                                    <td class="text-right">
                                        <span class="font-weight-semibold text-success">
                                            {{ number_format($project->total_value, 2) }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <a href="{{ route('warehouse.reports.stock-on-project.details', $project->id) }}"
                                           class="btn btn-sm btn-primary" title="View Detailed Stock Report">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="table-info">
                                <th colspan="3"><strong>Total</strong></th>
                                <th class="text-right">
                                    <strong>{{ number_format($projects->sum('unique_items')) }}</strong>
                                </th>
                                <th class="text-right">
                                    <strong>{{ number_format($projects->sum('total_stock')) }}</strong>
                                </th>
                                <th class="text-right">
                                    <strong class="text-success">{{ number_format($projects->sum('total_value'), 2) }}</strong>
                                </th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">business_center</i>
                    <h5 class="text-muted mb-2">No Projects Found</h5>
                    <p class="text-muted">
                        No projects match your current filter criteria.<br>
                        Try adjusting your filters or check if projects have been created.
                    </p>
                </div>
            @endif
        </div>
    </div>

    @if($projects->count() > 0)
    <!-- Summary Statistics -->
    <div class="row mt-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">work</i>
                        </div>
                        <div>
                            <div class="h5 mb-0">{{ $projects->count() }}</div>
                            <div class="small">Total Projects</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">inventory_2</i>
                        </div>
                        <div>
                            <div class="h5 mb-0">{{ number_format($projects->sum('unique_items')) }}</div>
                            <div class="small">Unique Items</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">inventory</i>
                        </div>
                        <div>
                            <div class="h5 mb-0">{{ number_format($projects->sum('total_stock')) }}</div>
                            <div class="small">Total Stock Quantity</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="mr-3">
                            <i class="material-icons" style="font-size: 36px;">attach_money</i>
                        </div>
                        <div>
                            <div class="h5 mb-0">{{ number_format($projects->sum('total_value'), 0) }}</div>
                            <div class="small">Total Value (AED)</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
@endsection

@push('scripts')
<script>
function exportReport() {
    alert('Export functionality will be implemented soon.');
}

function printReport() {
    window.print();
}
</script>
@endpush