@extends('layouts.admin-simple')

@section('title', 'Transaction Report')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item active">Transactions</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Transaction Report</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">All warehouse transaction history</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <button type="button" onclick="exportReport()" class="btn btn-sm btn-success mr-2" title="Export to Excel">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>
            <button type="button" onclick="printReport()" class="btn btn-sm btn-info" title="Print Report">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print
            </button>
        </div>
    </div>
@endsection

@section('content')
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Total Transactions"
                :value="$stats['total']"
                icon="receipt_long"
                color="primary"
                subtitle="All transactions"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Incoming Operations"
                :value="$stats['incoming']"
                icon="download"
                color="success"
                subtitle="Supply deliveries & returns"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Outgoing/DD"
                :value="$stats['outgoing'] + $stats['direct_deliveries']"
                icon="upload"
                color="info"
                subtitle="Outgoing & Direct Deliveries"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <x-warehouse.stats-card
                title="Transfers"
                :value="$stats['transfers']"
                icon="swap_horiz"
                color="warning"
                subtitle="Material transfers"
            />
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('warehouse.reports.transactions') }}">
                <div class="row">
                    <div class="col-xl-3 col-md-4 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="{{ request('search') }}" class="form-control" placeholder="Search transactions...">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Transaction Type</label>
                        <select name="type" class="form-control">
                            <option value="">All Types</option>
                            <option value="incoming" {{ request('type') == 'incoming' ? 'selected' : '' }}>Incoming Operations</option>
                            <option value="outgoing" {{ request('type') == 'outgoing' ? 'selected' : '' }}>Outgoing</option>
                            <option value="direct_delivery" {{ request('type') == 'direct_delivery' ? 'selected' : '' }}>Direct Delivery</option>
                            <option value="transfer" {{ request('type') == 'transfer' ? 'selected' : '' }}>Transfer</option>
                        </select>
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="{{ request('date_from') }}" class="form-control">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="{{ request('date_to') }}" class="form-control">
                    </div>

                    <div class="col-xl-2 col-md-4 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-control">
                            <option value="">All Status</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </div>

                    <div class="col-xl-1 col-md-12 mb-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                            Search
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Transaction List -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Transaction History</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Transaction ID</th>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Reference</th>
                            <th>Entity</th>
                            <th>Project</th>
                            <th>Status</th>
                            <th>Created By</th>
                            <th width="100">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $transaction)
                            <tr>
                                <td>{{ $transaction['id'] }}</td>
                                <td>{{ \Carbon\Carbon::parse($transaction['date'])->format('d-M-Y') }}</td>
                                <td>
                                    <span class="badge badge-{{ $transaction['type_badge'] }}">
                                        {{ $transaction['type'] }}
                                    </span>
                                </td>
                                <td>{{ $transaction['reference'] ?: '-' }}</td>
                                <td>{{ $transaction['entity'] }}</td>
                                <td>{{ $transaction['project'] }}</td>
                                <td>
                                    <span class="badge badge-{{ $transaction['status_badge'] }}">
                                        {{ $transaction['status'] }}
                                    </span>
                                </td>
                                <td>{{ $transaction['created_by'] }}</td>
                                <td>
                                    @if($transaction['model'] == 'incoming')
                                        <a href="{{ route('warehouse.incoming-operations.show', $transaction['model_id']) }}"
                                           class="btn btn-sm btn-info" title="View Details">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    @elseif($transaction['model'] == 'outgoing')
                                        <a href="{{ route('warehouse.outgoing.show', $transaction['model_id']) }}"
                                           class="btn btn-sm btn-info" title="View Details">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    @elseif($transaction['model'] == 'direct_delivery')
                                        <a href="{{ route('warehouse.direct-deliveries.show', $transaction['model_id']) }}"
                                           class="btn btn-sm btn-info" title="View Details">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    @elseif($transaction['model'] == 'transfer')
                                        <a href="{{ route('warehouse.transfer-requests.show', $transaction['model_id']) }}"
                                           class="btn btn-sm btn-info" title="View Details">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center">
                                    <p class="text-muted my-3">No transactions found</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination Links -->
            @if($transactions->hasPages())
                <div class="card-footer">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            Showing {{ $transactions->firstItem() }} to {{ $transactions->lastItem() }} of {{ $transactions->total() }} results
                        </div>
                        <div>
                            {{ $transactions->links('pagination::bootstrap-4') }}
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection

@section('scripts')
<script>
    function exportReport() {
        alert('Export functionality will be implemented');
    }

    function printReport() {
        window.print();
    }
</script>
@endsection