@extends('layouts.admin-simple')

@section('title', 'New Supplier Delivery')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.supplier-delivery.index') }}">Supplier Delivery</a></li>
    <li class="breadcrumb-item active">New Delivery</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">New Supplier Delivery</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Create a new supplier delivery operation</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.supplier-delivery.index') }}" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to List
            </a>
            <button type="submit" form="deliveryForm" class="btn btn-sm btn-primary">
                <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                Save Delivery
            </button>
        </div>
    </div>
@endsection

@section('content')
    <form id="deliveryForm" action="{{ route('warehouse.incoming-operations.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="operation_type" value="supplier_delivery">

        <!-- Basic Information Card -->
        <div class="card mb-3">
            <div class="card-header">
                <h6 class="card-title mb-0 d-flex align-items-center">
                    <i class="material-icons mr-2">info</i>
                    Basic Information
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="delivery_note_number">Delivery Note Number <span class="text-danger">*</span></label>
                            <input type="text" name="delivery_note_number" id="delivery_note_number"
                                   class="form-control @error('delivery_note_number') is-invalid @enderror"
                                   placeholder="Enter delivery note number" value="{{ old('delivery_note_number') }}" required>
                            @error('delivery_note_number')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="operation_date">Delivery Date <span class="text-danger">*</span></label>
                            <input type="date" name="operation_date" id="operation_date"
                                   class="form-control @error('operation_date') is-invalid @enderror"
                                   value="{{ old('operation_date', date('Y-m-d')) }}" required>
                            @error('operation_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="lpo_number">LPO Number</label>
                            <input type="text" name="lpo_number" id="lpo_number"
                                   class="form-control @error('lpo_number') is-invalid @enderror"
                                   placeholder="Enter LPO Number" value="{{ old('lpo_number') }}">
                            @error('lpo_number')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        @php
                            $supplierCreateOptions = [['value' => '', 'text' => 'Select Supplier']];
                            foreach($suppliers ?? [] as $supplier) {
                                $supplierCreateOptions[] = [
                                    'value' => $supplier->id,
                                    'text' => $supplier->name . ' (' . $supplier->supplier_code . ')'
                                ];
                            }
                        @endphp
                        <x-warehouse.select2-dropdown
                            name="supplier_id"
                            id="supplier_id"
                            label="Supplier Name"
                            placeholder="Select Supplier"
                            :options="$supplierCreateOptions"
                            :selected="old('supplier_id')"
                            required="true"
                            errorField="supplier_id"
                        />
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="division">Division <span class="text-danger">*</span></label>
                            <input type="text" name="division" id="division"
                                   class="form-control @error('division') is-invalid @enderror"
                                   placeholder="Enter division" value="{{ old('division') }}" required>
                            @error('division')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

            </div>
        </div>


        <!-- Materials & Items Card -->
        <div class="card mb-3">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6 class="card-title mb-0 d-flex align-items-center">
                    <i class="material-icons mr-2">inventory</i>
                    Materials & Items
                </h6>
                <button type="button" onclick="addItemRow()" class="btn btn-sm btn-primary">
                    <i class="material-icons mr-1" style="font-size: 14px;">add</i>
                    Add Item
                </button>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm mb-0" id="items-table">
                        <thead class="bg-light">
                            <tr>
                                <th style="width: 25%">Item</th>
                                <th style="width: 10%">Quantity</th>
                                <th style="width: 8%">Unit</th>
                                <th style="width: 12%">Unit Price</th>
                                <th style="width: 12%">Total Price</th>
                                <th style="width: 12%">Batch Number</th>
                                <th style="width: 10%">Production Date</th>
                                <th style="width: 10%">Expiry Date</th>
                                <th style="width: 8%">Actions</th>
                            </tr>
                        </thead>
                        <tbody id="items-tbody">
                            <!-- Item rows will be added here -->
                        </tbody>
                        <tfoot class="bg-light">
                            <tr>
                                <td colspan="4" class="text-right font-weight-bold">Total Amount (AED):</td>
                                <td class="font-weight-bold text-success">
                                    <span id="total-amount">0.00</span>
                                    <input type="hidden" name="total_amount" id="total_amount_input" value="0">
                                </td>
                                <td colspan="4"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        <!-- Received By & Additional Information Card -->
        <div class="card mb-3">
            <div class="card-header">
                <h6 class="card-title mb-0 d-flex align-items-center">
                    <i class="material-icons mr-2">person</i>
                    Received By & Additional Information
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        @php
                            $userCreateOptions = [['value' => '', 'text' => 'Select User']];
                            foreach($users ?? [] as $user) {
                                $userCreateOptions[] = [
                                    'value' => $user->id,
                                    'text' => $user->name
                                ];
                            }
                        @endphp
                        <x-warehouse.select2-dropdown
                            name="received_by"
                            id="received_by"
                            label="Received By"
                            placeholder="Select User"
                            :options="$userCreateOptions"
                            :selected="old('received_by')"
                            errorField="received_by"
                        />
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="received_by_name">Received By Name</label>
                            <input type="text" name="received_by_name" id="received_by_name"
                                   class="form-control @error('received_by_name') is-invalid @enderror"
                                   placeholder="Enter full name" value="{{ old('received_by_name', auth()->user()->name ?? '') }}">
                            @error('received_by_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="notes">Notes</label>
                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror"
                              rows="3" placeholder="Enter any additional notes or comments">{{ old('notes') }}</textarea>
                    @error('notes')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-check">
                            <input type="checkbox" name="regulatory_compliant" id="regulatory_compliant"
                                   class="form-check-input" value="1" {{ old('regulatory_compliant') ? 'checked' : '' }}>
                            <label class="form-check-label" for="regulatory_compliant">
                                Regulatory Compliant
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Form Actions -->
        <div class="card">
            <div class="card-body text-center py-3">
                <button type="submit" class="btn btn-primary mr-3">
                    <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                    Save as Draft
                </button>
                <button type="button" onclick="saveAndComplete()" class="btn btn-success mr-3">
                    <i class="material-icons mr-1" style="font-size: 16px;">check_circle</i>
                    Save & Mark as Delivered
                </button>
                <a href="{{ route('warehouse.supplier-delivery.index') }}" class="btn btn-outline-secondary">
                    <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                    Cancel
                </a>
            </div>
        </div>
    </form>
@endsection

@push('styles')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <style>
        .form-group label {
            font-weight: 600;
            color: #495057;
            font-size: 14px;
        }

        .card-title {
            font-size: 16px;
            font-weight: 600;
            color: #495057;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
            font-size: 13px;
        }

        .table td {
            vertical-align: middle;
            font-size: 13px;
        }

        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            line-height: 1.5;
        }

        .btn-sm .material-icons {
            font-size: 16px !important;
        }

        .form-control-sm {
            height: calc(1.5em + 0.5rem + 2px);
            padding: 0.25rem 0.5rem;
            font-size: 0.875rem;
        }

        .item-row {
            border-bottom: 1px solid #dee2e6;
        }

        .item-row:hover {
            background-color: #f8f9fa;
        }

        .select2-container .select2-selection--single {
            height: 38px;
            border: 1px solid #ced4da;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
        }

        .text-danger {
            color: #dc3545 !important;
        }

        .text-success {
            color: #28a745 !important;
        }

        .invalid-feedback {
            display: block;
        }
    </style>
@endpush

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        let itemRowCounter = 0;
        let availableItems = @json($items ?? []);

        $(document).ready(function() {
            // Initialize Select2
            $('#supplier_id, #received_by').select2({
                placeholder: 'Please select...',
                allowClear: true
            });

            // Items are already loaded from PHP

            // Auto-fill received by name when user is selected
            $('#received_by').change(function() {
                const selectedOption = $(this).find('option:selected');
                if (selectedOption.val()) {
                    $('#received_by_name').val(selectedOption.text());
                }
            });

            // Add initial item row
            addItemRow();
        });



        function addItemRow() {
            itemRowCounter++;
            const rowHtml = `
                <tr class="item-row" data-row="${itemRowCounter}">
                    <td>
                        <select name="items[${itemRowCounter}][item_id]" class="form-control form-control-sm item-select" required>
                            <option value="">Select Item</option>
                            ${availableItems.map(item => `<option value="${item.id}" data-unit="${item.unit_of_measure}">${item.item_description} (${item.item_code})</option>`).join('')}
                        </select>
                    </td>
                    <td>
                        <input type="number" name="items[${itemRowCounter}][quantity_delivered]" class="form-control form-control-sm quantity"
                               placeholder="0" step="0.01" min="0" required>
                    </td>
                    <td>
                        <input type="text" name="items[${itemRowCounter}][unit]" class="form-control form-control-sm unit-field"
                               placeholder="Unit" readonly>
                    </td>
                    <td>
                        <input type="number" name="items[${itemRowCounter}][unit_price]" class="form-control form-control-sm unit-price"
                               placeholder="0.00" step="0.01" min="0" required>
                    </td>
                    <td>
                        <input type="number" name="items[${itemRowCounter}][total_price]" class="form-control form-control-sm total-price"
                               placeholder="0.00" step="0.01" min="0" readonly>
                    </td>
                    <td>
                        <input type="text" name="items[${itemRowCounter}][batch_number]" class="form-control form-control-sm"
                               placeholder="Batch">
                    </td>
                    <td>
                        <input type="date" name="items[${itemRowCounter}][production_date]" class="form-control form-control-sm">
                    </td>
                    <td>
                        <input type="date" name="items[${itemRowCounter}][expiry_date]" class="form-control form-control-sm">
                    </td>
                    <td>
                        <button type="button" onclick="removeItemRow(${itemRowCounter})" class="btn btn-sm btn-outline-danger">
                            <i class="material-icons" style="font-size: 14px;">delete</i>
                        </button>
                    </td>
                </tr>
            `;

            $('#items-tbody').append(rowHtml);

            // Bind events to new row
            bindRowEvents(itemRowCounter);
        }

        function bindRowEvents(rowCounter) {
            const row = $(`.item-row[data-row="${rowCounter}"]`);

            // Update unit when item is selected
            row.find('.item-select').change(function() {
                const selectedOption = $(this).find('option:selected');
                const unit = selectedOption.data('unit');
                row.find('.unit-field').val(unit || '');
            });

            // Calculate line total when quantity or price changes
            row.find('.quantity, .unit-price').on('input', function() {
                const quantity = parseFloat(row.find('.quantity').val()) || 0;
                const unitPrice = parseFloat(row.find('.unit-price').val()) || 0;
                const total = quantity * unitPrice;

                row.find('.total-price').val(total.toFixed(2));
                calculateTotals();
            });
        }

        function removeItemRow(rowCounter) {
            $(`.item-row[data-row="${rowCounter}"]`).remove();
            calculateTotals();
        }

        function calculateTotals() {
            let total = 0;

            $('.total-price').each(function() {
                const value = parseFloat($(this).val()) || 0;
                total += value;
            });

            $('#total-amount').text(total.toFixed(2));
            $('#total_amount_input').val(total);
        }

        function saveAndComplete() {
            $('#status').val('delivered');
            $('#deliveryForm').submit();
        }

        // Form validation
        $('#deliveryForm').on('submit', function(e) {
            const itemsCount = $('#items-tbody tr').length;
            if (itemsCount === 0) {
                e.preventDefault();
                alert('Please add at least one item to the delivery.');
                return false;
            }
        });
    </script>
@endpush