@extends('layouts.admin-simple')

@section('title', 'Transfer Request Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">
                        <i class="material-icons mr-2">swap_horiz</i>
                        Transfer Request: {{ $transferRequest->transfer_request_number }}
                    </h4>
                    <div>
                        <span class="badge badge-{{ $transferRequest->status_color }} badge-lg">
                            {{ ucfirst(str_replace('_', ' ', $transferRequest->status)) }}
                        </span>
                    </div>
                </div>

                <div class="card-body">
                    <!-- Request Details -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5 class="border-bottom pb-2 mb-3">Request Information</h5>
                            <table class="table table-sm table-borderless">
                                <tr>
                                    <td width="40%" class="font-weight-semibold">Request Date:</td>
                                    <td>{{ $transferRequest->request_date->format('F d, Y') }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-semibold">Priority:</td>
                                    <td>
                                        <span class="badge badge-{{ $transferRequest->priority_color }}">
                                            {{ ucfirst($transferRequest->priority) }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="font-weight-semibold">Required Date:</td>
                                    <td>
                                        @if($transferRequest->required_date)
                                            {{ $transferRequest->required_date->format('F d, Y') }}
                                        @else
                                            <span class="text-muted">Not specified</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="font-weight-semibold">Requested By:</td>
                                    <td>{{ $transferRequest->requestedBy->name }}</td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <h5 class="border-bottom pb-2 mb-3">Project Details</h5>
                            <table class="table table-sm table-borderless">
                                <tr>
                                    <td width="40%" class="font-weight-semibold">From Project:</td>
                                    <td class="text-primary">{{ $transferRequest->transferrerProject->project_name }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-semibold">To Project:</td>
                                    <td class="text-success">{{ $transferRequest->receiverProject->project_name }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-semibold">Transfer Reason:</td>
                                    <td>{{ $transferRequest->transfer_reason }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Transfer Status -->
                    @if($transferRequest->status !== 'draft')
                    <div class="row mb-4">
                        <div class="col-12">
                            <h5 class="border-bottom pb-2 mb-3">Transfer Status</h5>
                            <div class="row">
                                <div class="col-md-8 mx-auto">
                                    <div class="card border-primary">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">Transfer Dispatch</h6>
                                        </div>
                                        <div class="card-body">
                                            @if($transferRequest->transferrer_approved_at)
                                                <div class="text-success mb-2">
                                                    <i class="material-icons mr-1">local_shipping</i>
                                                    Transferred
                                                </div>
                                                <p class="small mb-1">
                                                    <strong>By:</strong> {{ $transferRequest->transferrerApprovedBy->name }}<br>
                                                    <strong>Date:</strong> {{ $transferRequest->transferrer_approved_at->format('F d, Y H:i') }}
                                                </p>
                                                @if($transferRequest->transferrer_approval_notes)
                                                <p class="small mb-0">
                                                    <strong>Notes:</strong> {{ $transferRequest->transferrer_approval_notes }}
                                                </p>
                                                @endif
                                            @else
                                                <div class="text-warning">
                                                    <i class="material-icons mr-1">schedule</i>
                                                    Pending Transfer
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Items -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h5 class="border-bottom pb-2 mb-3">Requested Items</h5>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Item</th>
                                            <th>Available Qty</th>
                                            <th>Requested Qty</th>
                                            <th>Transferred Qty</th>
                                            <th>Unit Price</th>
                                            <th>Total Value</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($transferRequest->items as $item)
                                        <tr>
                                            <td>
                                                <strong>{{ $item->item->item_name }}</strong>
                                                @if($item->item->item_code)
                                                <br><small class="text-muted">{{ $item->item->item_code }}</small>
                                                @endif
                                            </td>
                                            <td>{{ number_format($item->quantity_available, 2) }}</td>
                                            <td>{{ number_format($item->quantity_requested, 2) }}</td>
                                            <td>
                                                @if($item->quantity_approved > 0)
                                                    {{ number_format($item->quantity_approved, 2) }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($item->estimated_unit_price)
                                                    AED {{ number_format($item->estimated_unit_price, 2) }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($item->estimated_total_value)
                                                    AED {{ number_format($item->estimated_total_value, 2) }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                <span class="badge badge-{{ $item->approval_status_color }}">
                                                    {{ ucfirst($item->approval_status) }}
                                                </span>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot class="bg-light">
                                        <tr>
                                            <th colspan="4">Total</th>
                                            <th>{{ $transferRequest->total_items_count }} items</th>
                                            <th>AED {{ number_format($transferRequest->total_estimated_value, 2) }}</th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Notes -->
                    @if($transferRequest->transfer_notes)
                    <div class="row mb-4">
                        <div class="col-12">
                            <h5 class="border-bottom pb-2 mb-3">Additional Notes</h5>
                            <div class="bg-light p-3 rounded">
                                {{ $transferRequest->transfer_notes }}
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Transfer Issue -->
                    @if($transferRequest->transferIssue)
                    <div class="row mb-4">
                        <div class="col-12">
                            <h5 class="border-bottom pb-2 mb-3">Transfer Issue</h5>
                            <div class="card border-success">
                                <div class="card-body">
                                    <h6>
                                        <a href="{{ route('warehouse.transfer-issues.show', $transferRequest->transferIssue) }}" class="text-primary">
                                            {{ $transferRequest->transferIssue->transfer_issue_number }}
                                        </a>
                                        <span class="badge badge-{{ $transferRequest->transferIssue->status_color }} ml-2">
                                            {{ ucfirst(str_replace('_', ' ', $transferRequest->transferIssue->status)) }}
                                        </span>
                                    </h6>
                                    <p class="mb-0">
                                        <strong>Issue Date:</strong> {{ $transferRequest->transferIssue->issue_date->format('F d, Y') }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-6">
                            <a href="{{ route('warehouse.transfer-requests.index') }}" class="btn btn-secondary">
                                <i class="material-icons mr-1">arrow_back</i>
                                Back to List
                            </a>
                        </div>
                        <div class="col-md-6 text-right">
                            @if($transferRequest->status === 'draft')
                            <a href="{{ route('warehouse.transfer-requests.edit', $transferRequest) }}" class="btn btn-warning">
                                <i class="material-icons mr-1">edit</i>
                                Edit Request
                            </a>
                            @endif

                            @if($transferRequest->canCreateTransferIssue())
                            <a href="{{ route('warehouse.transfer-issues.create', $transferRequest) }}" class="btn btn-success">
                                <i class="material-icons mr-1">local_shipping</i>
                                Create Transfer Issue
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection