# Warehouse Management System - Route Structure

## Navigation and Routing Overview

This document outlines the complete routing structure for the KCG Warehouse Management System.

### Route Groups and Middleware

#### Main Warehouse Group
- **Prefix**: `/warehouse`
- **Middleware**: `auth`, `warehouse.access`
- **Name Prefix**: `warehouse.`

#### API Group
- **Prefix**: `/api/warehouse`
- **Middleware**: `auth`, `warehouse.access`
- **Name Prefix**: `api.warehouse.`

### Core Routes

#### Dashboard
- `GET /warehouse` → `warehouse.dashboard`
- `GET /warehouse/dashboard` → `warehouse.dashboard.alt`

#### Items Management
- `GET /warehouse/items` → `warehouse.items.index`
- `GET /warehouse/items/create` → `warehouse.items.create`
- `POST /warehouse/items` → `warehouse.items.store`
- `GET /warehouse/items/{item}` → `warehouse.items.show`
- `GET /warehouse/items/{item}/edit` → `warehouse.items.edit`
- `PUT /warehouse/items/{item}` → `warehouse.items.update`
- `DELETE /warehouse/items/{item}` → `warehouse.items.destroy`

**Special Item Routes:**
- `POST /warehouse/items/bulk-import` → `warehouse.items.bulk-import`
- `GET /warehouse/items/export` → `warehouse.items.export`
- `GET /warehouse/items/{item}/barcode` → `warehouse.items.barcode`
- `GET /warehouse/items/{item}/qr-code` → `warehouse.items.qr-code`

#### Inventory Management
- `GET /warehouse/inventory` → `warehouse.inventory.index`
- `GET /warehouse/inventory/{inventory}` → `warehouse.inventory.show`

**Stock Adjustments:**
- `GET /warehouse/inventory/adjustments/create` → `warehouse.inventory.adjustments.create`
- `POST /warehouse/inventory/adjustments` → `warehouse.inventory.adjustments.store`
- `GET /warehouse/inventory/adjustments` → `warehouse.inventory.adjustments`

**Stock Transfers:**
- `GET /warehouse/inventory/transfers/create` → `warehouse.inventory.transfers.create`
- `POST /warehouse/inventory/transfers` → `warehouse.inventory.transfers.store`
- `GET /warehouse/inventory/transfers` → `warehouse.inventory.transfers`

**Physical Count:**
- `GET /warehouse/inventory/physical-count` → `warehouse.inventory.physical-count`
- `POST /warehouse/inventory/physical-count` → `warehouse.inventory.physical-count.store`

#### Suppliers Management
- `GET /warehouse/suppliers` → `warehouse.suppliers.index`
- `GET /warehouse/suppliers/create` → `warehouse.suppliers.create`
- `POST /warehouse/suppliers` → `warehouse.suppliers.store`
- `GET /warehouse/suppliers/{supplier}` → `warehouse.suppliers.show`
- `GET /warehouse/suppliers/{supplier}/edit` → `warehouse.suppliers.edit`
- `PUT /warehouse/suppliers/{supplier}` → `warehouse.suppliers.update`
- `DELETE /warehouse/suppliers/{supplier}` → `warehouse.suppliers.destroy`

**Supplier Operations:**
- `GET /warehouse/suppliers/{supplier}/items` → `warehouse.suppliers.items`
- `GET /warehouse/suppliers/{supplier}/transactions` → `warehouse.suppliers.transactions`
- `POST /warehouse/suppliers/{supplier}/toggle-status` → `warehouse.suppliers.toggle-status`

#### Projects Management
- `GET /warehouse/projects` → `warehouse.projects.index`
- `GET /warehouse/projects/create` → `warehouse.projects.create`
- `POST /warehouse/projects` → `warehouse.projects.store`
- `GET /warehouse/projects/{project}` → `warehouse.projects.show`
- `GET /warehouse/projects/{project}/edit` → `warehouse.projects.edit`
- `PUT /warehouse/projects/{project}` → `warehouse.projects.update`
- `DELETE /warehouse/projects/{project}` → `warehouse.projects.destroy`

**Project Operations:**
- `GET /warehouse/projects/{project}/items` → `warehouse.projects.items`
- `GET /warehouse/projects/{project}/transactions` → `warehouse.projects.transactions`
- `POST /warehouse/projects/{project}/close` → `warehouse.projects.close`

#### Categories Management
- `GET /warehouse/categories` → `warehouse.categories.index`
- `GET /warehouse/categories/create` → `warehouse.categories.create`
- `POST /warehouse/categories` → `warehouse.categories.store`
- `GET /warehouse/categories/{category}` → `warehouse.categories.show`
- `GET /warehouse/categories/{category}/edit` → `warehouse.categories.edit`
- `PUT /warehouse/categories/{category}` → `warehouse.categories.update`
- `DELETE /warehouse/categories/{category}` → `warehouse.categories.destroy`

#### Incoming Transactions
- `GET /warehouse/incoming` → `warehouse.incoming.index`
- `GET /warehouse/incoming/create` → `warehouse.incoming.create`
- `POST /warehouse/incoming` → `warehouse.incoming.store`
- `GET /warehouse/incoming/{transaction}` → `warehouse.incoming.show`
- `GET /warehouse/incoming/{transaction}/edit` → `warehouse.incoming.edit`
- `PUT /warehouse/incoming/{transaction}` → `warehouse.incoming.update`
- `DELETE /warehouse/incoming/{transaction}` → `warehouse.incoming.destroy`

**Transaction Operations:**
- `POST /warehouse/incoming/{transaction}/receive` → `warehouse.incoming.receive`
- `POST /warehouse/incoming/{transaction}/complete` → `warehouse.incoming.complete`
- `GET /warehouse/incoming/{transaction}/print` → `warehouse.incoming.print`

#### Outgoing Transactions
- `GET /warehouse/outgoing` → `warehouse.outgoing.index`
- `GET /warehouse/outgoing/create` → `warehouse.outgoing.create`
- `POST /warehouse/outgoing` → `warehouse.outgoing.store`
- `GET /warehouse/outgoing/{transaction}` → `warehouse.outgoing.show`
- `GET /warehouse/outgoing/{transaction}/edit` → `warehouse.outgoing.edit`
- `PUT /warehouse/outgoing/{transaction}` → `warehouse.outgoing.update`
- `DELETE /warehouse/outgoing/{transaction}` → `warehouse.outgoing.destroy`

**Transaction Operations:**
- `POST /warehouse/outgoing/{transaction}/approve` → `warehouse.outgoing.approve`
- `POST /warehouse/outgoing/{transaction}/dispatch` → `warehouse.outgoing.dispatch`
- `GET /warehouse/outgoing/{transaction}/print` → `warehouse.outgoing.print`

#### Return Transactions
- `GET /warehouse/returns` → `warehouse.returns.index`
- `GET /warehouse/returns/create` → `warehouse.returns.create`
- `POST /warehouse/returns` → `warehouse.returns.store`
- `GET /warehouse/returns/{transaction}` → `warehouse.returns.show`
- `GET /warehouse/returns/{transaction}/edit` → `warehouse.returns.edit`
- `PUT /warehouse/returns/{transaction}` → `warehouse.returns.update`
- `DELETE /warehouse/returns/{transaction}` → `warehouse.returns.destroy`

**Return Operations:**
- `POST /warehouse/returns/{transaction}/process` → `warehouse.returns.process`
- `GET /warehouse/returns/{transaction}/print` → `warehouse.returns.print`

#### Stock Movements
- `GET /warehouse/stock-movements` → `warehouse.stock-movements.index`
- `GET /warehouse/stock-movements/{movement}` → `warehouse.stock-movements.show`
- `GET /warehouse/stock-movements/item/{item}` → `warehouse.stock-movements.by-item`

#### Material Delivery Notes
- `GET /warehouse/delivery-notes` → `warehouse.delivery-notes.index`
- `GET /warehouse/delivery-notes/create` → `warehouse.delivery-notes.create`
- `POST /warehouse/delivery-notes` → `warehouse.delivery-notes.store`
- `GET /warehouse/delivery-notes/{note}` → `warehouse.delivery-notes.show`
- `GET /warehouse/delivery-notes/{note}/print` → `warehouse.delivery-notes.print`

#### Reports
- `GET /warehouse/reports` → `warehouse.reports.index`
- `GET /warehouse/reports/inventory` → `warehouse.reports.inventory`
- `GET /warehouse/reports/transactions` → `warehouse.reports.transactions`
- `GET /warehouse/reports/stock-movements` → `warehouse.reports.stock-movements`
- `GET /warehouse/reports/low-stock` → `warehouse.reports.low-stock`
- `GET /warehouse/reports/supplier-performance` → `warehouse.reports.supplier-performance`
- `GET /warehouse/reports/project-consumption` → `warehouse.reports.project-consumption`
- `GET /warehouse/reports/expiry-alerts` → `warehouse.reports.expiry-alerts`
- `GET /warehouse/reports/custom` → `warehouse.reports.custom`

**Export Routes:**
- `POST /warehouse/reports/export/inventory` → `warehouse.reports.export.inventory`
- `POST /warehouse/reports/export/transactions` → `warehouse.reports.export.transactions`
- `POST /warehouse/reports/export/stock-movements` → `warehouse.reports.export.stock-movements`

#### Settings
- `GET /warehouse/settings` → `warehouse.settings.index`
- `POST /warehouse/settings/update` → `warehouse.settings.update`
- `GET /warehouse/settings/backup` → `warehouse.settings.backup`
- `POST /warehouse/settings/restore` → `warehouse.settings.restore`

#### Notifications
- `GET /warehouse/notifications` → `warehouse.notifications.index`
- `POST /warehouse/notifications/{notification}/mark-read` → `warehouse.notifications.mark-read`
- `POST /warehouse/notifications/mark-all-read` → `warehouse.notifications.mark-all-read`

#### Profile & Preferences
- `GET /warehouse/profile/edit` → `warehouse.profile.edit`
- `PUT /warehouse/profile/update` → `warehouse.profile.update`
- `GET /warehouse/profile/preferences` → `warehouse.profile.preferences`
- `POST /warehouse/profile/preferences` → `warehouse.profile.preferences.update`

#### Utilities
- `GET /warehouse/search` → `warehouse.search`
- `GET /warehouse/quick-access/{type}` → `warehouse.quick-access`

### API Routes

#### Item Operations
- `GET /api/warehouse/items/search` → `api.warehouse.items.search`
- `GET /api/warehouse/items/{item}/stock` → `api.warehouse.items.stock`
- `GET /api/warehouse/items/by-barcode/{barcode}` → `api.warehouse.items.by-barcode`

#### Supplier Operations
- `GET /api/warehouse/suppliers/search` → `api.warehouse.suppliers.search`

#### Project Operations
- `GET /api/warehouse/projects/search` → `api.warehouse.projects.search`
- `GET /api/warehouse/projects/{project}/items` → `api.warehouse.projects.items`

#### Inventory Operations
- `GET /api/warehouse/inventory/check-availability` → `api.warehouse.inventory.check-availability`
- `POST /api/warehouse/inventory/reserve` → `api.warehouse.inventory.reserve`
- `POST /api/warehouse/inventory/release` → `api.warehouse.inventory.release`

#### Dashboard Data
- `GET /api/warehouse/dashboard/stats` → `api.warehouse.dashboard.stats`
- `GET /api/warehouse/dashboard/recent-activity` → `api.warehouse.dashboard.recent-activity`
- `GET /api/warehouse/dashboard/alerts` → `api.warehouse.dashboard.alerts`

#### Notification Operations
- `GET /api/warehouse/notifications/unread-count` → `api.warehouse.notifications.unread-count`
- `GET /api/warehouse/notifications/recent` → `api.warehouse.notifications.recent`

### Permission Requirements

Each route group is protected by specific permissions:

- **Items**: `warehouse.items.view`, `warehouse.items.create`, `warehouse.items.edit`, `warehouse.items.delete`
- **Inventory**: `warehouse.inventory.view`, `warehouse.inventory.adjust`, `warehouse.inventory.transfer`, `warehouse.inventory.count`
- **Suppliers**: `warehouse.suppliers.view`, `warehouse.suppliers.create`, `warehouse.suppliers.edit`, `warehouse.suppliers.delete`
- **Projects**: `warehouse.projects.view`, `warehouse.projects.create`, `warehouse.projects.edit`, `warehouse.projects.delete`
- **Incoming**: `warehouse.incoming.view`, `warehouse.incoming.create`, `warehouse.incoming.edit`, `warehouse.incoming.delete`, `warehouse.incoming.process`
- **Outgoing**: `warehouse.outgoing.view`, `warehouse.outgoing.create`, `warehouse.outgoing.edit`, `warehouse.outgoing.delete`, `warehouse.outgoing.approve`, `warehouse.outgoing.process`
- **Returns**: `warehouse.returns.view`, `warehouse.returns.create`, `warehouse.returns.edit`, `warehouse.returns.delete`, `warehouse.returns.process`
- **Reports**: `warehouse.reports.view`
- **Settings**: `warehouse.settings.manage`

### Middleware Chain

1. **auth**: Ensures user is authenticated
2. **warehouse.access**: Checks basic warehouse access permissions
3. **warehouse.permission:specific.permission**: Checks specific feature permissions

This structure provides comprehensive access control while maintaining flexibility for different user roles within the warehouse system.