<?php $__env->startSection('title', 'Outgoing Request Details - ' . $requestSummary->material_request_number); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.index')); ?>">Reports</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.outgoing')); ?>">Outgoing Materials</a></li>
    <li class="breadcrumb-item active">Request Details</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1"><?php echo e($requestSummary->material_request_number); ?></h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Material request details and dispatch methods</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="<?php echo e(route('warehouse.reports.outgoing')); ?>" class="btn btn-sm btn-outline-secondary">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Report
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Request Summary Card -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">assignment</i>
                Request Summary
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-borderless table-sm mb-0">
                        <tr>
                            <td class="font-weight-medium">Request Number:</td>
                            <td class="text-primary font-weight-bold"><?php echo e($requestSummary->material_request_number); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Request Date:</td>
                            <td><?php echo e($requestSummary->transaction_date->format('d-M-Y')); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Project:</td>
                            <td><?php echo e($requestSummary->project_name); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Division:</td>
                            <td><?php echo e($requestSummary->division_name); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Requested By:</td>
                            <td><?php echo e($requestSummary->requester_name); ?></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-borderless table-sm mb-0">
                        <tr>
                            <td class="font-weight-medium">Receiver:</td>
                            <td><?php echo e($requestSummary->receiver_name ?: 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Delivery Location:</td>
                            <td><?php echo e($requestSummary->delivery_location ?: 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Purpose:</td>
                            <td><?php echo e($requestSummary->purpose ?: 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Overall Status:</td>
                            <td>
                                <?php if($requestSummary->overall_status == 'Fully Dispatched'): ?>
                                    <span class="badge badge-success"><?php echo e($requestSummary->overall_status); ?></span>
                                <?php elseif($requestSummary->overall_status == 'Pending'): ?>
                                    <span class="badge badge-warning"><?php echo e($requestSummary->overall_status); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-info"><?php echo e($requestSummary->overall_status); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Items Count:</td>
                            <td><span class="badge badge-light"><?php echo e($requestSummary->total_items); ?> items</span></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Statistics -->
    <div class="row mb-4">
        <div class="col-md-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Requested','value' => number_format($requestSummary->total_requested, 2),'icon' => 'inventory_2','color' => 'info','subtitle' => 'Total quantity requested']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Requested','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($requestSummary->total_requested, 2)),'icon' => 'inventory_2','color' => 'info','subtitle' => 'Total quantity requested']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-md-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Released','value' => number_format($requestSummary->total_released, 2),'icon' => 'outbound','color' => 'success','subtitle' => 'Total quantity released']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Released','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($requestSummary->total_released, 2)),'icon' => 'outbound','color' => 'success','subtitle' => 'Total quantity released']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-md-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Pending Balance','value' => number_format($requestSummary->total_balance, 2),'icon' => 'pending_actions','color' => 'warning','subtitle' => 'Total quantity pending']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pending Balance','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($requestSummary->total_balance, 2)),'icon' => 'pending_actions','color' => 'warning','subtitle' => 'Total quantity pending']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Items Details -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">list_alt</i>
                Materials and Dispatch Methods
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th style="width: 15%;">Item Code</th>
                            <th style="width: 25%;">Description</th>
                            <th style="width: 10%;">Category</th>
                            <th style="width: 8%;">Unit</th>
                            <th style="width: 8%;">Requested</th>
                            <th style="width: 8%;">Released</th>
                            <th style="width: 8%;">Balance</th>
                            <th style="width: 10%;">Status</th>
                            <th style="width: 8%;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <code><?php echo e($item->item_code); ?></code>
                                </td>
                                <td>
                                    <div><?php echo e($item->item_description); ?></div>
                                </td>
                                <td>
                                    <span class="badge badge-outline-secondary small"><?php echo e($item->category); ?></span>
                                </td>
                                <td class="text-center"><?php echo e($item->unit); ?></td>
                                <td class="text-right">
                                    <strong><?php echo e(number_format($item->quantity_requested, 2)); ?></strong>
                                </td>
                                <td class="text-right">
                                    <strong class="text-success"><?php echo e(number_format($item->quantity_released, 2)); ?></strong>
                                </td>
                                <td class="text-right">
                                    <strong class="<?php echo e($item->quantity_balance > 0 ? 'text-warning' : 'text-success'); ?>">
                                        <?php echo e(number_format($item->quantity_balance, 2)); ?>

                                    </strong>
                                </td>
                                <td>
                                    <?php if($item->fulfillment_status == 'Fully Dispatched'): ?>
                                        <span class="badge badge-success"><?php echo e($item->fulfillment_status); ?></span>
                                    <?php elseif($item->fulfillment_status == 'Pending'): ?>
                                        <span class="badge badge-warning"><?php echo e($item->fulfillment_status); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-info"><?php echo e($item->fulfillment_status); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php if(count($item->dispatch_methods) > 0): ?>
                                        <button type="button"
                                                class="btn btn-sm btn-outline-primary"
                                                onclick="showDispatchMethods('<?php echo e($item->item_code); ?>', <?php echo e(json_encode($item->dispatch_methods)); ?>)"
                                                title="View dispatch methods">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </button>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<!-- Dispatch Methods Modal -->
<div class="modal fade" id="dispatchMethodsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="material-icons align-middle mr-1">local_shipping</i>
                    Dispatch Methods - <span id="modalItemCode"></span>
                </h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body" id="dispatchMethodsContent">
                <!-- Content will be loaded dynamically -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
    <style>
        .badge-outline-secondary {
            color: #6c757d;
            border: 1px solid #6c757d;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
            white-space: nowrap;
        }

        .table td {
            vertical-align: middle;
            font-size: 13px;
        }

        .badge {
            font-size: 10px;
            padding: 3px 6px;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }

        .dispatch-method-item {
            border-left: 3px solid #dee2e6;
            padding: 12px;
            margin-bottom: 12px;
            background-color: #f8f9fa;
            border-radius: 0 4px 4px 0;
        }

        .dispatch-method-item.success { border-left-color: #28a745; }
        .dispatch-method-item.info { border-left-color: #17a2b8; }
        .dispatch-method-item.primary { border-left-color: #007bff; }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function showDispatchMethods(itemCode, methods) {
            $('#modalItemCode').text(itemCode);

            let content = '';
            if (methods.length === 0) {
                content = '<div class="text-center py-4"><i class="material-icons text-muted mb-3" style="font-size: 48px;">local_shipping_off</i><h5 class="text-muted">No Dispatch Methods</h5><p class="text-muted mb-0">This item has not been dispatched yet.</p></div>';
            } else {
                methods.forEach(function(method) {
                    content += `
                        <div class="dispatch-method-item ${method.color}">
                            <div class="d-flex align-items-center mb-2">
                                <i class="material-icons mr-2" style="color: var(--${method.color});">${method.icon}</i>
                                <h6 class="mb-0 font-weight-bold">${method.type}</h6>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <strong>Quantity:</strong> ${parseFloat(method.quantity).toFixed(2)}
                                </div>
                                <div class="col-md-6">
                                    <strong>Date:</strong> ${method.date}
                                </div>
                            </div>
                            ${method.supplier ? `<div class="mt-2"><strong>Supplier:</strong> ${method.supplier}</div>` : ''}
                            ${method.source_project ? `<div class="mt-2"><strong>Source Project:</strong> ${method.source_project}</div>` : ''}
                        </div>
                    `;
                });
            }

            $('#dispatchMethodsContent').html(content);
            $('#dispatchMethodsModal').modal('show');
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/outgoing-request-details.blade.php ENDPATH**/ ?>