<?php $__env->startSection('title', 'Incoming Operations'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item active">Incoming Operations</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Incoming Operations</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Enhanced construction materials receiving system</p>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.create')): ?>
        <div class="page-actions-right d-flex align-items-center">
            <div class="btn-group">
                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
                    <i class="material-icons mr-1">add</i>
                    New Operation
                </button>
                <div class="dropdown-menu dropdown-menu-right">
                    <a class="dropdown-item" href="<?php echo e(route('warehouse.incoming-operations.create', ['type' => 'supplier_delivery'])); ?>">
                        <i class="material-icons mr-2">local_shipping</i>
                        Supplier Delivery
                    </a>
                    <a class="dropdown-item" href="<?php echo e(route('warehouse.incoming-operations.create', ['type' => 'site_return'])); ?>">
                        <i class="material-icons mr-2">assignment_return</i>
                        Site Return
                    </a>
                    <a class="dropdown-item" href="<?php echo e(route('warehouse.incoming-operations.create', ['type' => 'emergency_procurement'])); ?>">
                        <i class="material-icons mr-2">warning</i>
                        Emergency Procurement
                    </a>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Layout Debug Info -->
    <div class="alert alert-info mb-4">
        <strong>Debug Info:</strong>
        Layout loaded successfully. If you can see this message and the navigation sidebar, the layout is working correctly.
        <br><small>Current route: <?php echo e(request()->route()->getName()); ?></small>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <h5 class="card-title text-uppercase text-muted mb-0">Total Operations</h5>
                            <span class="h2 font-weight-bold mb-0"><?php echo e($operations->count() ?? 0); ?></span>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-primary text-white rounded-circle shadow">
                                <i class="material-icons">input</i>
                            </div>
                        </div>
                    </div>
                    <p class="mt-3 mb-0 text-muted text-sm">
                        <span class="text-nowrap">All incoming operations</span>
                    </p>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <h5 class="card-title text-uppercase text-muted mb-0">Direct Processing</h5>
                            <span class="h2 font-weight-bold mb-0"><?php echo e($operations->whereIn('operation_type', ['supplier_delivery', 'site_return'])->count() ?? 0); ?></span>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-warning text-white rounded-circle shadow">
                                <i class="material-icons">flash_on</i>
                            </div>
                        </div>
                    </div>
                    <p class="mt-3 mb-0 text-muted text-sm">
                        <span class="text-nowrap">Auto-processed operations</span>
                    </p>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <h5 class="card-title text-uppercase text-muted mb-0">Pending Review</h5>
                            <span class="h2 font-weight-bold mb-0"><?php echo e($operations->whereIn('status', ['pending_inspection', 'approved'])->count() ?? 0); ?></span>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-success text-white rounded-circle shadow">
                                <i class="material-icons">check_circle</i>
                            </div>
                        </div>
                    </div>
                    <p class="mt-3 mb-0 text-muted text-sm">
                        <span class="text-nowrap">Needs manual approval</span>
                    </p>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <h5 class="card-title text-uppercase text-muted mb-0">Completed</h5>
                            <span class="h2 font-weight-bold mb-0"><?php echo e($operations->where('status', 'completed')->count() ?? 0); ?></span>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-info text-white rounded-circle shadow">
                                <i class="material-icons">done_all</i>
                            </div>
                        </div>
                    </div>
                    <p class="mt-3 mb-0 text-muted text-sm">
                        <span class="text-nowrap">Inventory updated</span>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Simple Operations List -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">list</i>
                Operations List
            </h5>
        </div>
        <div class="card-body">
            <?php if($operations->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Operation #</th>
                                <th>Type</th>
                                <th>Date</th>
                                <th>Supplier/Source</th>
                                <th>Status</th>
                                <th>Total (AED)</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $operations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($operation->operation_number); ?></td>
                                    <td>
                                        <span class="badge badge-primary">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $operation->operation_type))); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($operation->operation_date); ?></td>
                                    <td><?php echo e($operation->supplier->name ?? '-'); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo e($operation->status === 'completed' ? 'success' : ($operation->status === 'pending_inspection' ? 'warning' : 'secondary')); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $operation->status))); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e(number_format($operation->total_amount_aed ?? 0, 2)); ?></td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('warehouse.incoming-operations.show', $operation->id)); ?>" class="btn btn-sm btn-outline-primary">
                                                <i class="material-icons" style="font-size: 16px;">visibility</i>
                                            </a>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.edit')): ?>
                                            <a href="<?php echo e(route('warehouse.incoming-operations.edit', $operation->id)); ?>" class="btn btn-sm btn-outline-success">
                                                <i class="material-icons" style="font-size: 16px;">edit</i>
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if($operations->hasPages()): ?>
                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($operations->links()); ?>

                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="text-center py-4">
                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">inbox</i>
                    <h5 class="text-muted">No Operations Found</h5>
                    <p class="text-muted mb-4">There are no incoming operations to display.</p>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.create')): ?>
                        <a href="<?php echo e(route('warehouse.incoming-operations.create', ['type' => 'supplier_delivery'])); ?>" class="btn btn-primary">
                            <i class="material-icons mr-1">add</i>
                            Create First Operation
                        </a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- JavaScript Debug -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('✅ Incoming Operations page loaded successfully');
            console.log('✅ Layout structure:', {
                header: document.querySelector('#header') ? 'Found' : 'Missing',
                sidebar: document.querySelector('.mdk-drawer') ? 'Found' : 'Missing',
                content: document.querySelector('.page') ? 'Found' : 'Missing',
                preloader: document.querySelector('.preloader') ? 'Found' : 'Missing'
            });

            // Hide preloader if it's still showing
            const preloader = document.querySelector('.preloader');
            if (preloader) {
                setTimeout(() => {
                    preloader.style.display = 'none';
                }, 1000);
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .icon {
            width: 3rem;
            height: 3rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .icon-shape {
            padding: 12px;
            text-align: center;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .bg-primary {
            background-color: #5e72e4 !important;
        }

        .bg-warning {
            background-color: #fb6340 !important;
        }

        .bg-success {
            background-color: #2dce89 !important;
        }

        .bg-info {
            background-color: #11cdef !important;
        }

        .rounded-circle {
            border-radius: 50% !important;
        

        .shadow {
            box-shadow: 0 0.15rem 1.75rem 0 rgba(33, 40, 50, 0.15) !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/incoming-operations/index.blade.php ENDPATH**/ ?>