<?php $__env->startSection('title', 'Site Return Operations'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item active">Site Return</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Site Return Operations</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Manage returns from construction sites</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <button type="button" onclick="exportReturns()" class="btn btn-sm btn-info mr-2" title="Export returns to Excel">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>

            <a href="<?php echo e(route('warehouse.site-return.create')); ?>" class="btn btn-sm btn-primary" title="Add new site return">
                <i class="material-icons mr-1" style="font-size: 16px;">add</i>
                New Return
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Projects with Returns','value' => $statistics['total_projects_with_returns'] ?? 0,'icon' => 'business','color' => 'warning','subtitle' => 'Active projects']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Projects with Returns','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['total_projects_with_returns'] ?? 0),'icon' => 'business','color' => 'warning','subtitle' => 'Active projects']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Returns','value' => $statistics['total_returns'] ?? 0,'icon' => 'assignment_return','color' => 'primary','subtitle' => 'All site returns']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Returns','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['total_returns'] ?? 0),'icon' => 'assignment_return','color' => 'primary','subtitle' => 'All site returns']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Material Requests','value' => $statistics['total_material_requests'] ?? 0,'icon' => 'assignment','color' => 'success','subtitle' => 'With returns']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Material Requests','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['total_material_requests'] ?? 0),'icon' => 'assignment','color' => 'success','subtitle' => 'With returns']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Items Returned','value' => number_format($statistics['total_items_returned'] ?? 0),'icon' => 'inventory_2','color' => 'info','subtitle' => 'Total items']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Items Returned','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($statistics['total_items_returned'] ?? 0)),'icon' => 'inventory_2','color' => 'info','subtitle' => 'Total items']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-xl-3 col-md-6 mb-3">
                    <?php
                        $projectFilterOptions = [['value' => '', 'text' => 'All Projects']];
                        foreach($allProjects ?? [] as $project) {
                            $projectFilterOptions[] = [
                                'value' => $project->id,
                                'text' => $project->project_name
                            ];
                        }
                    ?>
                    <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'filter-project','id' => 'filter-project','label' => 'Project','placeholder' => 'All Projects','options' => $projectFilterOptions,'allowClear' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'filter-project','id' => 'filter-project','label' => 'Project','placeholder' => 'All Projects','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($projectFilterOptions),'allowClear' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <label class="form-label">Search Project</label>
                    <input type="text" id="filter-search" class="form-control" placeholder="Search project name...">
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <?php
                        $divisionFilterOptions = [['value' => '', 'text' => 'All Divisions']];
                        $uniqueDivisions = $allProjects->unique('projectDivision.division_name')->filter(function($project) {
                            return $project->projectDivision;
                        });
                        foreach($uniqueDivisions as $project) {
                            $divisionFilterOptions[] = [
                                'value' => $project->projectDivision->division_name,
                                'text' => $project->projectDivision->division_name
                            ];
                        }
                    ?>
                    <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'filter-division','id' => 'filter-division','label' => 'Division','placeholder' => 'All Divisions','options' => $divisionFilterOptions,'allowClear' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'filter-division','id' => 'filter-division','label' => 'Division','placeholder' => 'All Divisions','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($divisionFilterOptions),'allowClear' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'filter-sort','id' => 'filter-sort','label' => 'Sort By','placeholder' => 'Select Sort Order','options' => [
                            ['value' => 'latest_return', 'text' => 'Latest Return Date'],
                            ['value' => 'project_name', 'text' => 'Project Name'],
                            ['value' => 'most_returns', 'text' => 'Most Returns'],
                            ['value' => 'total_items', 'text' => 'Total Items']
                        ],'selected' => 'latest_return','allowClear' => 'false']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'filter-sort','id' => 'filter-sort','label' => 'Sort By','placeholder' => 'Select Sort Order','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
                            ['value' => 'latest_return', 'text' => 'Latest Return Date'],
                            ['value' => 'project_name', 'text' => 'Project Name'],
                            ['value' => 'most_returns', 'text' => 'Most Returns'],
                            ['value' => 'total_items', 'text' => 'Total Items']
                        ]),'selected' => 'latest_return','allowClear' => 'false']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                </div>
            </div>

            <div class="d-flex justify-content-between align-items-center mt-3 pt-3 border-top">
                <button type="button" onclick="applyFilters()" class="btn btn-primary">
                    <i class="material-icons mr-1" style="font-size: 18px; vertical-align: middle;">filter_list</i>
                    Apply Filters
                </button>

                <button type="button" onclick="clearFilters()" class="btn btn-outline-secondary">
                    <i class="material-icons mr-1" style="font-size: 18px; vertical-align: middle;">clear</i>
                    Clear Filters
                </button>
            </div>
        </div>
    </div>

    <!-- Site Returns Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">business</i>
                Projects with Site Returns
            </h5>
            <div class="d-flex align-items-center">
                <label class="text-muted mr-2" style="font-size: 14px;">Show:</label>
                <select id="entries-per-page" class="form-control form-control-sm" style="width: auto;">
                    <option value="10">10</option>
                    <option value="25" selected>25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
                <span class="text-muted ml-2" style="font-size: 14px;">entries</span>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="returns-table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>Project</th>
                            <th>Division</th>
                            <th>Total Returns</th>
                            <th>Material Requests</th>
                            <th>Latest Return Date</th>
                            <th>Status</th>
                            <th>Items Returned</th>
                            <th>Total Value (AED)</th>
                            <th class="text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Projects with returns data -->
                        <?php if(isset($projects) && $projects->count() > 0): ?>
                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="mr-3">
                                                <div class="bg-info text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 40px; height: 40px;">
                                                    <i class="material-icons" style="font-size: 18px;">business</i>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="font-weight-medium"><?php echo e($project->project_name); ?></div>
                                                <small class="text-muted"><?php echo e($project->project_number ?: 'No project number'); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-secondary"><?php echo e($project->project_division ?: 'N/A'); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge badge-primary"><?php echo e($project->total_returns); ?> <?php echo e($project->total_returns > 1 ? 'returns' : 'return'); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge badge-info"><?php echo e($project->material_requests_count); ?> MRs</span>
                                    </td>
                                    <td><?php echo e($project->latest_return_date ? \Carbon\Carbon::parse($project->latest_return_date)->format('d/m/Y') : 'N/A'); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo e($project->primary_status === 'completed' ? 'success' :
                                            ($project->primary_status === 'pending_processing' ? 'warning' :
                                            ($project->primary_status === 'processing' ? 'info' :
                                            ($project->primary_status === 'rejected' ? 'danger' : 'secondary')))); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $project->primary_status))); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-outline-primary"><?php echo e(number_format($project->total_items_returned)); ?> items</span>
                                    </td>
                                    <td>
                                        <div class="text-right">
                                            <div class="font-weight-medium">AED <?php echo e(number_format($project->total_value_returned ?? 0, 2)); ?></div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <?php if($project->project_id == 0): ?>
                                                <a href="<?php echo e(route('warehouse.site-return.index')); ?>?unassigned=1" class="btn btn-sm btn-outline-primary" title="View Unassigned Returns">
                                                    <i class="material-icons" style="font-size: 16px;">visibility</i>
                                                </a>
                                                <button onclick="exportUnassignedReturns()" class="btn btn-sm btn-outline-info" title="Export Unassigned Returns">
                                                    <i class="material-icons" style="font-size: 16px;">file_download</i>
                                                </button>
                                            <?php else: ?>
                                                <a href="<?php echo e(route('warehouse.site-return.project-returns', $project->project_id)); ?>" class="btn btn-sm btn-outline-primary" title="View Project Returns">
                                                    <i class="material-icons" style="font-size: 16px;">visibility</i>
                                                </a>
                                                <button onclick="exportProjectReturns(<?php echo e($project->project_id); ?>)" class="btn btn-sm btn-outline-info" title="Export Project Returns">
                                                    <i class="material-icons" style="font-size: 16px;">file_download</i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center py-4">
                                    <i class="material-icons text-muted mb-3" style="font-size: 48px;">business</i>
                                    <h5 class="text-muted">No Projects with Returns Found</h5>
                                    <p class="text-muted mb-4">No projects have site returns matching your current filters.</p>
                                    <a href="<?php echo e(route('warehouse.site-return.create')); ?>" class="btn btn-primary">
                                        <i class="material-icons mr-1">add</i>
                                        Create First Return
                                    </a>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
        </div>
    </div>

    <!-- Quick Statistics -->
    <div class="row mt-4">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">trending_up</i>
                        Recent Activity
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex align-items-center px-0">
                            <div class="mr-3">
                                <div class="bg-success text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 32px; height: 32px;">
                                    <i class="material-icons" style="font-size: 16px;">check</i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">Today's Processing</h6>
                                <small class="text-muted"><?php echo e($statistics['processed_today'] ?? 0); ?> returns processed</small>
                            </div>
                        </div>
                        <div class="list-group-item d-flex align-items-center px-0">
                            <div class="mr-3">
                                <div class="bg-warning text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 32px; height: 32px;">
                                    <i class="material-icons" style="font-size: 16px;">schedule</i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">Pending Processing</h6>
                                <small class="text-muted"><?php echo e($statistics['pending_processing'] ?? 0); ?> awaiting processing</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">work</i>
                        Top Return Reasons
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <?php if(isset($topReturnReasons)): ?>
                            <?php $__currentLoopData = $topReturnReasons->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reason => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item d-flex align-items-center px-0">
                                    <div class="mr-3">
                                        <div class="bg-info text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 32px; height: 32px;">
                                            <span style="font-size: 12px; font-weight: bold;"><?php echo e($count); ?></span>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h6 class="mb-0"><?php echo e(ucwords(str_replace('_', ' ', $reason))); ?></h6>
                                        <small class="text-muted"><?php echo e($count); ?> returns</small>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="text-center py-3">
                                <small class="text-muted">No return data available</small>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>

        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        .badge-outline-info {
            color: #17a2b8;
            border: 1px solid #17a2b8;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function applyFilters() {
            // Implement filtering logic
            console.log('Applying filters...');
            // You can implement AJAX filtering here
        }

        function clearFilters() {
            $('#filter-status, #filter-mr-reference, #filter-project, #filter-division, #filter-return-reason, #filter-date-from, #filter-date-to, #filter-amount-min, #filter-amount-max').val('');
            applyFilters();
        }

        function exportReturns() {
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Exporting...';
            btn.disabled = true;

            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.disabled = false;
                alert('Export functionality will be implemented');
            }, 1000);
        }

        function printReturnNote(returnId) {
            window.open(`<?php echo e(url('warehouse/incoming-operations')); ?>/${returnId}/print`, '_blank');
        }

        function printMRReturns(materialRequestId) {
            alert('Print MR returns functionality will be implemented');
        }

        function exportProjectReturns(projectId) {
            alert('Export project returns functionality will be implemented');
        }

        function exportUnassignedReturns() {
            alert('Export unassigned returns functionality will be implemented');
        }

        // Auto-refresh every 5 minutes
        setInterval(() => {
            window.location.reload();
        }, 300000);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/site-return/index.blade.php ENDPATH**/ ?>