<?php $__env->startSection('title', 'Create Material Request'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .pulse-error {
        animation: pulse-red 1s ease-in-out 3;
        border-color: #dc3545 !important;
    }

    @keyframes pulse-red {
        0% {
            box-shadow: 0 0 0 0 rgba(220, 53, 69, 0.7);
        }
        70% {
            box-shadow: 0 0 0 10px rgba(220, 53, 69, 0);
        }
        100% {
            box-shadow: 0 0 0 0 rgba(220, 53, 69, 0);
        }
    }

    .select2-container .select2-selection.pulse-error {
        animation: pulse-red 1s ease-in-out 3;
        border-color: #dc3545 !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">assignment</i>
                        Create Material Request
                    </h1>
                    <p class="text-muted mb-0">Request materials from inventory for project use</p>
                </div>
                <div>
                    <a href="<?php echo e(route('warehouse.outgoing.index')); ?>" class="btn btn-secondary">
                        <i class="material-icons mr-1">arrow_back</i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Container -->
    <div class="card shadow">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="material-icons align-middle mr-1">assignment</i>
                Material Request Form
            </h6>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('warehouse.outgoing.store')); ?>" method="POST" id="materialRequestForm">
                <?php echo csrf_field(); ?>

                <!-- Request Information -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="font-weight-bold text-secondary mb-3">
                            <i class="material-icons align-middle mr-1">info</i>
                            Request Information
                        </h6>
                        <div class="row">
                            <!-- Date -->
                            <div class="col-md-4 mb-3">
                                <label for="request_date" class="form-label">Request Date <span class="text-danger">*</span></label>
                                <input type="date"
                                       class="form-control <?php $__errorArgs = ['request_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="request_date"
                                       name="request_date"
                                       value="<?php echo e(old('request_date', date('Y-m-d'))); ?>"
                                       required>
                                <?php $__errorArgs = ['request_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Material Request Number -->
                            <div class="col-md-4 mb-3">
                                <label for="material_request_number" class="form-label">Material Request Number <span class="text-danger">*</span></label>
                                <input type="text"
                                       class="form-control <?php $__errorArgs = ['material_request_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="material_request_number"
                                       name="material_request_number"
                                       value="<?php echo e(old('material_request_number', 'MR-' . date('Ymd') . '-' . str_pad(rand(1, 999), 3, '0', STR_PAD_LEFT))); ?>"
                                       placeholder="Auto-generated request number"
                                       required>
                                <?php $__errorArgs = ['material_request_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Requested By -->
                            <div class="col-md-4 mb-3">
                                <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'requested_by','id' => 'requested_by','label' => 'Requested By','placeholder' => 'Select Requester','options' => isset($users) ? $users->map(function($user) {
                                        return ['value' => $user->id, 'text' => $user->name];
                                    }) : [],'selected' => old('requested_by'),'required' => true,'allowClear' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'requested_by','id' => 'requested_by','label' => 'Requested By','placeholder' => 'Select Requester','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(isset($users) ? $users->map(function($user) {
                                        return ['value' => $user->id, 'text' => $user->name];
                                    }) : []),'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('requested_by')),'required' => true,'allowClear' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Project -->
                            <div class="col-md-12 mb-3">
                                <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'project_id','id' => 'project_id','label' => 'Project Number & Name','placeholder' => 'Select Project','options' => isset($projects) ? $projects->map(function($project) {
                                        return [
                                            'value' => $project->id,
                                            'text' => $project->project_number . ' - ' . $project->project_name,
                                            'data' => [
                                                'division' => $project->division_id ?? '',
                                                'division-name' => $project->division->name ?? ''
                                            ]
                                        ];
                                    }) : [],'selected' => old('project_id'),'required' => true,'allowClear' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'project_id','id' => 'project_id','label' => 'Project Number & Name','placeholder' => 'Select Project','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(isset($projects) ? $projects->map(function($project) {
                                        return [
                                            'value' => $project->id,
                                            'text' => $project->project_number . ' - ' . $project->project_name,
                                            'data' => [
                                                'division' => $project->division_id ?? '',
                                                'division-name' => $project->division->name ?? ''
                                            ]
                                        ];
                                    }) : []),'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('project_id')),'required' => true,'allowClear' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>

                                <!-- Division Display Box -->
                                <div id="division_display" class="mt-2" style="display: none;">
                                    <div class="alert alert-info py-2 mb-0">
                                        <strong>Division:</strong> <span id="division_name_display"></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <hr class="my-4">

                <!-- Items Section -->
                <div class="row">
                    <div class="col-12">
                        <h6 class="font-weight-bold text-secondary mb-3">
                            <i class="material-icons align-middle mr-1">shopping_cart</i>
                            Items Selection & Management
                        </h6>

                        <!-- Items Table -->
                        <div class="table-responsive">
                            <table class="table table-bordered" id="items-table">
                                <thead class="thead-light">
                                    <tr>
                                        <th width="50%">Item</th>
                                        <th width="25%">Requested Qty</th>
                                        <th width="20%">Unit</th>
                                        <th width="5%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="items-tbody">
                                    <tr>
                                        <td>
                                            <select name="items[0][item_id]" class="form-control item-select" onchange="updateItemRow(this, 0)" required>
                                                <option value="">Select Item</option>
                                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>"
                                                        data-code="<?php echo e($item->item_code); ?>"
                                                        data-description="<?php echo e($item->item_description); ?>"
                                                        data-unit="<?php echo e($item->unit_of_measure); ?>"
                                                        data-stock="<?php echo e($item->current_stock ?? 0); ?>">
                                                    <?php echo e($item->item_code); ?> - <?php echo e($item->item_description); ?>

                                                </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
                                        <td>
                                            <input type="number" name="items[0][quantity_requested]" class="form-control" step="0.01" min="0.01" required>
                                        </td>
                                        <td>
                                            <input type="text" name="items[0][unit_of_measure]" class="form-control" readonly>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeItemRow(this)">
                                                <i class="material-icons">delete</i>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <!-- Add Row Button -->
                        <div class="mb-3">
                            <button type="button" class="btn btn-outline-primary" onclick="addItemRow()">
                                <i class="material-icons mr-1">add</i>
                                Add Another Item
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <hr class="my-4">
                <div class="row">
                    <div class="col-12">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="text-muted">
                                <i class="material-icons align-middle mr-1">info</i>
                                <strong>Summary:</strong> <span id="total_items_display">0 items</span>
                            </div>
                            <div>
                                <a href="<?php echo e(route('warehouse.outgoing.index')); ?>" class="btn btn-outline-secondary mr-2">
                                    <i class="material-icons mr-1">arrow_back</i>
                                    Cancel
                                </a>
                                <button type="submit" class="btn btn-success" id="submit_request_btn" disabled>
                                    <i class="material-icons mr-1">send</i>
                                    Submit Material Request
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Information Card -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card border-left-success">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                <i class="material-icons align-middle mr-1">info</i>
                                Material Request Process
                            </div>
                            <div class="text-gray-800">
                                <ul class="mb-0 pl-3">
                                    <li>Material requests are processed directly upon approval</li>
                                    <li>Once approved, inventory will be automatically updated</li>
                                    <li>Requested items will be deducted from available stock immediately</li>
                                    <li>You can track all material requests through the inventory section</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="material-icons fa-2x text-gray-300">check_circle</i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
let rowCounter = 1;

$(document).ready(function() {
    console.log('🚀 Material Request Form: Initializing...');

    // Project selection change handler
    $('#project_id').off('change.materialRequest').on('change.materialRequest', function() {
        const selectedOption = $(this).find('option:selected');
        const divisionDisplay = $('#division_display');
        const divisionNameDisplay = $('#division_name_display');

        if (selectedOption.val() && selectedOption.data('division-name')) {
            divisionNameDisplay.text(selectedOption.data('division-name'));
            divisionDisplay.show();
        } else {
            divisionDisplay.hide();
        }
    });

    // Form submission validation
    $('#materialRequestForm').off('submit.materialRequest').on('submit.materialRequest', function(e) {
        console.log('📋 Form submission triggered');

        // Validate required fields
        let isValid = true;
        let missingFields = [];

        // Check request date
        if (!$('#request_date').val()) {
            isValid = false;
            missingFields.push('Request Date');
            $('#request_date').addClass('is-invalid');
        } else {
            $('#request_date').removeClass('is-invalid');
        }

        // Check material request number
        if (!$('#material_request_number').val()) {
            isValid = false;
            missingFields.push('Material Request Number');
            $('#material_request_number').addClass('is-invalid');
        } else {
            $('#material_request_number').removeClass('is-invalid');
        }

        // Check project selection
        if (!$('#project_id').val()) {
            isValid = false;
            missingFields.push('Project');
            $('#project_id').next('.select2-container').find('.select2-selection').addClass('is-invalid');
        } else {
            $('#project_id').next('.select2-container').find('.select2-selection').removeClass('is-invalid');
        }

        // Check requested by
        if (!$('#requested_by').val()) {
            isValid = false;
            missingFields.push('Requested By');
            $('#requested_by').next('.select2-container').find('.select2-selection').addClass('is-invalid');
        } else {
            $('#requested_by').next('.select2-container').find('.select2-selection').removeClass('is-invalid');
        }

        // Check if there are items
        const hasItems = $('#items-tbody tr').length > 0;
        if (!hasItems) {
            isValid = false;
            missingFields.push('Items');
        } else {
            // Validate each item row
            $('#items-tbody tr').each(function(index) {
                const itemSelect = $(this).find('select[name*="item_id"]');
                const quantityInput = $(this).find('input[name*="quantity_requested"]');

                if (!itemSelect.val()) {
                    isValid = false;
                    missingFields.push(`Item selection in row ${index + 1}`);
                    itemSelect.addClass('is-invalid');
                } else {
                    itemSelect.removeClass('is-invalid');
                }

                if (!quantityInput.val() || quantityInput.val() <= 0) {
                    isValid = false;
                    missingFields.push(`Quantity in row ${index + 1}`);
                    quantityInput.addClass('is-invalid');
                } else {
                    quantityInput.removeClass('is-invalid');
                }
            });
        }

        if (!isValid) {
            e.preventDefault();
            alert('Please fill in the following required fields:\n\n• ' + missingFields.join('\n• '));

            // Focus on the first missing field and scroll to it
            setTimeout(function() {
                if (!$('#request_date').val()) {
                    $('#request_date').addClass('pulse-error').focus();
                    $('html, body').animate({scrollTop: $('#request_date').offset().top - 100}, 500);
                    setTimeout(() => $('#request_date').removeClass('pulse-error'), 3000);
                } else if (!$('#material_request_number').val()) {
                    $('#material_request_number').addClass('pulse-error').focus();
                    $('html, body').animate({scrollTop: $('#material_request_number').offset().top - 100}, 500);
                    setTimeout(() => $('#material_request_number').removeClass('pulse-error'), 3000);
                } else if (!$('#project_id').val()) {
                    $('#project_id').next('.select2-container').find('.select2-selection').addClass('pulse-error');
                    $('#project_id').select2('open');
                    $('html, body').animate({scrollTop: $('#project_id').offset().top - 100}, 500);
                    setTimeout(() => $('#project_id').next('.select2-container').find('.select2-selection').removeClass('pulse-error'), 3000);
                } else if (!$('#requested_by').val()) {
                    $('#requested_by').next('.select2-container').find('.select2-selection').addClass('pulse-error');
                    $('#requested_by').select2('open');
                    $('html, body').animate({scrollTop: $('#requested_by').offset().top - 100}, 500);
                    setTimeout(() => $('#requested_by').next('.select2-container').find('.select2-selection').removeClass('pulse-error'), 3000);
                } else {
                    // Focus on first invalid item field
                    const firstInvalidItem = $('#items-tbody tr').first().find('select[name*="item_id"]');
                    if (firstInvalidItem.length) {
                        firstInvalidItem.addClass('pulse-error').select2('open');
                        $('html, body').animate({scrollTop: firstInvalidItem.offset().top - 100}, 500);
                        setTimeout(() => firstInvalidItem.removeClass('pulse-error'), 3000);
                    }
                }
            }, 100);

            return false;
        }

        console.log('✅ Form validation passed, submitting...');
    });

    // Enable submit button initially since we have one row
    updateSubmitButton();

    // Add click handler to submit button for debugging
    $('#submit_request_btn').off('click.debug').on('click.debug', function(e) {
        console.log('🖱️ Submit button clicked');
        const isDisabled = $(this).prop('disabled');
        if (isDisabled) {
            console.log('⚠️ Button is disabled');
            e.preventDefault();
            return false;
        }
        console.log('✅ Button click proceeding');
    });

    // Add event listeners to clear validation errors when user interacts with fields
    $('#request_date').on('change', function() {
        $(this).removeClass('is-invalid');
    });

    $('#material_request_number').on('input', function() {
        if ($(this).val()) {
            $(this).removeClass('is-invalid');
        }
    });

    $('#project_id').on('select2:select', function() {
        $(this).next('.select2-container').find('.select2-selection').removeClass('is-invalid');
    });

    $('#requested_by').on('select2:select', function() {
        $(this).next('.select2-container').find('.select2-selection').removeClass('is-invalid');
    });

    // Add event listener for quantity inputs (using event delegation)
    $(document).on('input', 'input[name*="quantity_requested"]', function() {
        if ($(this).val() && $(this).val() > 0) {
            $(this).removeClass('is-invalid');
        }
    });

    console.log('✅ Material Request Form: Initialization complete');
});


// Update submit button state
function updateSubmitButton() {
    const hasRows = $('#items-tbody tr').length > 0;
    const submitBtn = $('#submit_request_btn');

    console.log('🔘 Updating submit button - Rows:', hasRows, 'Button found:', submitBtn.length > 0);

    if (hasRows) {
        submitBtn.prop('disabled', false);
        console.log('✅ Submit button enabled');
    } else {
        submitBtn.prop('disabled', true);
        console.log('❌ Submit button disabled');
    }
}

// Update item row when item is selected
function updateItemRow(selectElement, rowIndex) {
    const selectedOption = selectElement.options[selectElement.selectedIndex];

    if (selectedOption.value) {
        const unit = selectedOption.dataset.unit || '';

        // Update unit
        const unitInput = selectElement.closest('tr').querySelector('input[name*="unit_of_measure"]');
        if (unitInput) {
            unitInput.value = unit;
        }

        // Remove error styling if item is selected
        $(selectElement).removeClass('is-invalid');
    } else {
        // Clear fields when no item selected
        const unitInput = selectElement.closest('tr').querySelector('input[name*="unit_of_measure"]');
        if (unitInput) {
            unitInput.value = '';
        }
    }
}


// Add a new item row
function addItemRow() {
    const tbody = document.getElementById('items-tbody');
    const newRow = document.createElement('tr');

    newRow.innerHTML = `
        <td>
            <select name="items[${rowCounter}][item_id]" class="form-control item-select" onchange="updateItemRow(this, ${rowCounter})" required>
                <option value="">Select Item</option>
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($item->id); ?>"
                        data-code="<?php echo e($item->item_code); ?>"
                        data-description="<?php echo e($item->item_description); ?>"
                        data-unit="<?php echo e($item->unit_of_measure); ?>"
                        data-stock="<?php echo e($item->current_stock ?? 0); ?>">
                    <?php echo e($item->item_code); ?> - <?php echo e($item->item_description); ?>

                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </td>
        <td>
            <input type="number" name="items[${rowCounter}][quantity_requested]" class="form-control" step="0.01" min="0.01" required>
        </td>
        <td>
            <input type="text" name="items[${rowCounter}][unit_of_measure]" class="form-control" readonly>
        </td>
        <td>
            <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeItemRow(this)">
                <i class="material-icons">delete</i>
            </button>
        </td>
    `;

    tbody.appendChild(newRow);
    rowCounter++;

    // Update submit button state
    updateSubmitButton();
}

// Remove an item row
function removeItemRow(button) {
    const tbody = document.getElementById('items-tbody');
    const rowToRemove = button.closest('tr');

    // Don't allow removing the last row
    if (tbody.children.length > 1) {
        rowToRemove.remove();
    } else {
        alert('At least one item row is required');
    }

    // Update submit button state
    updateSubmitButton();
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/outgoing/create.blade.php ENDPATH**/ ?>