<?php $__env->startSection('title', 'Material Request Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">assignment</i>
                        Material Request Details
                    </h1>
                    <p class="text-muted mb-0">Request #<?php echo e($materialRequest['request_number']); ?></p>
                </div>
                <div>
                    <a href="<?php echo e(route('warehouse.inventory.material-requests')); ?>" class="btn btn-secondary">
                        <i class="material-icons mr-1">arrow_back</i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Alert -->
    <?php if($materialRequest['status'] === 'pending'): ?>
        <div class="alert alert-warning">
            <i class="material-icons align-middle mr-2">pending</i>
            <strong>Pending Approval:</strong> This material request is waiting for manager approval and dispatch.
        </div>
    <?php elseif($materialRequest['status'] === 'successful'): ?>
        <div class="alert alert-success">
            <i class="material-icons align-middle mr-2">check_circle</i>
            <strong>Successful:</strong> Materials have been approved and dispatched successfully. Inventory has been updated.
        </div>
    <?php elseif($materialRequest['status'] === 'canceled'): ?>
        <div class="alert alert-danger">
            <i class="material-icons align-middle mr-2">cancel</i>
            <strong>Canceled:</strong> This material request has been canceled and no materials were dispatched.
        </div>
    <?php endif; ?>

    <div class="row">
        <!-- Request Details -->
        <div class="col-lg-8">
            <!-- Request Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">info</i>
                        Request Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Request Number:</strong><br><?php echo e($materialRequest['request_number']); ?></p>
                            <?php if($materialRequest['material_request_number']): ?>
                                <p><strong>Material Request Number:</strong><br><?php echo e($materialRequest['material_request_number']); ?></p>
                            <?php endif; ?>
                            <p><strong>Request Date:</strong><br><?php echo e($materialRequest['request_date']); ?></p>
                            <p><strong>Status:</strong><br>
                                <?php switch($materialRequest['status']):
                                    case ('pending'): ?>
                                        <span class="badge badge-warning">
                                            <i class="material-icons" style="font-size: 12px;">pending</i>
                                            Pending Approval
                                        </span>
                                        <?php break; ?>
                                    <?php case ('successful'): ?>
                                        <span class="badge badge-success">
                                            <i class="material-icons" style="font-size: 12px;">check_circle</i>
                                            Successful
                                        </span>
                                        <?php break; ?>
                                    <?php case ('canceled'): ?>
                                        <span class="badge badge-danger">
                                            <i class="material-icons" style="font-size: 12px;">cancel</i>
                                            Canceled
                                        </span>
                                        <?php break; ?>
                                <?php endswitch; ?>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Requested By:</strong><br><?php echo e($materialRequest['requested_by']); ?></p>
                            <p><strong>Project:</strong><br><?php echo e($materialRequest['project']); ?></p>
                            <?php if($materialRequest['notes']): ?>
                                <p><strong>Notes:</strong><br><?php echo e($materialRequest['notes']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Items -->
            <div class="card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">shopping_cart</i>
                        Requested Items (<?php echo e(count($materialRequest['items'])); ?>)
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>Item Code</th>
                                    <th>Description</th>
                                    <th>Unit</th>
                                    <th>Qty Requested</th>
                                    <th>Qty Released</th>
                                    <th>Balance</th>
                                    <th>Available Stock</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $materialRequest['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <strong class="text-primary"><?php echo e($item['item_code']); ?></strong>
                                        </td>
                                        <td><?php echo e($item['description']); ?></td>
                                        <td class="text-center">
                                            <span class="badge badge-secondary"><?php echo e($item['unit']); ?></span>
                                        </td>
                                        <td class="text-right"><?php echo e(number_format($item['quantity_requested'], 2)); ?></td>
                                        <td class="text-right">
                                            <?php if($item['quantity_released'] > 0): ?>
                                                <span class="text-success"><?php echo e(number_format($item['quantity_released'], 2)); ?></span>
                                            <?php else: ?>
                                                <span class="text-muted"><?php echo e(number_format($item['quantity_released'], 2)); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-right">
                                            <?php if($item['quantity_remaining'] > 0): ?>
                                                <span class="text-warning"><?php echo e(number_format($item['quantity_remaining'], 2)); ?></span>
                                            <?php else: ?>
                                                <span class="text-success">0.00</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-<?php echo e($item['quantity_available'] >= $item['quantity_requested'] ? 'success' : 'danger'); ?>">
                                                <?php echo e(number_format($item['quantity_available'], 2)); ?>

                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center text-muted py-4">
                                            <i class="material-icons mb-2" style="font-size: 48px; opacity: 0.3;">shopping_cart</i>
                                            <div>No items found in this request</div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Quick Actions -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">settings</i>
                        Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <a href="<?php echo e(route('warehouse.inventory.material-requests')); ?>" class="btn btn-outline-primary btn-block">
                        <i class="material-icons mr-1">list</i>
                        All Requests
                    </a>
                </div>
            </div>

            <!-- Request Summary -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">assessment</i>
                        Summary
                    </h6>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Items:</span>
                        <strong><?php echo e(count($materialRequest['items'])); ?></strong>
                    </div>
                    <?php
                        $canFulfill = collect($materialRequest['items'])->every(function($item) {
                            return $item['quantity_available'] >= $item['quantity_remaining'];
                        });
                    ?>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Qty Requested:</span>
                        <strong><?php echo e(number_format($materialRequest['total_requested'], 2)); ?></strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Qty Released:</span>
                        <strong><?php echo e(number_format($materialRequest['total_released'], 2)); ?></strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Total Qty Remaining:</span>
                        <strong class="text-warning"><?php echo e(number_format($materialRequest['total_remaining'], 2)); ?></strong>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between">
                        <span>Can Fulfill:</span>
                        <span class="badge badge-<?php echo e($canFulfill ? 'success' : 'danger'); ?>">
                            <?php echo e($canFulfill ? 'Yes' : 'No'); ?>

                        </span>
                    </div>
                </div>
            </div>

            <!-- Activity Timeline -->
            <div class="card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">timeline</i>
                        Request Timeline
                    </h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <!-- Created -->
                        <div class="timeline-item">
                            <div class="timeline-marker bg-primary"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Request Created</h6>
                                <p class="timeline-text">
                                    <?php echo e($materialRequest['request_date']); ?>

                                    <br><small class="text-muted">by <?php echo e($materialRequest['requested_by']); ?></small>
                                </p>
                            </div>
                        </div>

                        <?php if($materialRequest['status'] === 'successful'): ?>
                        <!-- Successful -->
                        <div class="timeline-item">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Approved & Dispatched</h6>
                                <p class="timeline-text">
                                    Materials dispatched and inventory updated
                                </p>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if($materialRequest['status'] === 'canceled'): ?>
                        <!-- Canceled -->
                        <div class="timeline-item">
                            <div class="timeline-marker bg-danger"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Request Canceled</h6>
                                <p class="timeline-text">
                                    Request was canceled before dispatch
                                </p>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .timeline {
        position: relative;
        padding-left: 30px;
    }
    .timeline:before {
        content: '';
        position: absolute;
        left: 8px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #e3e6f0;
    }
    .timeline-item {
        position: relative;
        margin-bottom: 20px;
    }
    .timeline-marker {
        position: absolute;
        left: -22px;
        top: 5px;
        width: 16px;
        height: 16px;
        border-radius: 50%;
        border: 2px solid #fff;
    }
    .timeline-title {
        font-size: 14px;
        font-weight: 600;
        color: #5a5c69;
        margin-bottom: 5px;
    }
    .timeline-text {
        font-size: 13px;
        color: #858796;
        margin-bottom: 0;
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/inventory/material-requests/view.blade.php ENDPATH**/ ?>