<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Admin Panel'); ?> - <?php echo e(config('app.name')); ?></title>

    <!-- Admin Favicon -->
    <link rel="icon" type="image/png" href="<?php echo e(asset($siteSettings['admin_favicon'] ?? $siteSettings['site_favicon'] ?? 'images/favicon.ico')); ?>">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

    <!-- Temporary fix - removed problematic built assets -->
    <style>
        * { font-family: 'Poppins', sans-serif !important; }
        body { background-color: #f4f6f9 !important; }
    </style>

    <!-- Material Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <!-- Material Icons fallback from CDN -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/material-design-icons/3.0.1/iconfont/material-icons.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

    <!-- DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/css/dataTables.bootstrap4.min.css"
          onerror="console.error('❌ DataTables CSS failed to load');"
          onload="console.log('✅ DataTables CSS loaded');">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/datatables.net-responsive-bs4@2.4.1/css/responsive.bootstrap4.min.css"
          onerror="console.error('❌ DataTables Responsive CSS failed to load');"
          onload="console.log('✅ DataTables Responsive CSS loaded');">

    <!-- DataTables CSS Fallback -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Check if DataTables CSS loaded by checking for specific styles
            setTimeout(function() {
                if (!document.querySelector('link[href*="dataTables"]')) {
                    console.log('🔄 Loading DataTables CSS fallback...');
                    const fallbackCSS = document.createElement('link');
                    fallbackCSS.rel = 'stylesheet';
                    fallbackCSS.href = 'https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/dataTables.bootstrap4.min.css';
                    document.head.appendChild(fallbackCSS);
                }
            }, 100);
        });
    </script>

    <!-- Admin Assets -->
    <link type="text/css" href="<?php echo e(asset('admin-assets/css/app.css')); ?>" rel="stylesheet">

    <!-- Admin Custom Styles -->
    <link type="text/css" href="<?php echo e(asset('admin-assets/css/admin-custom.css')); ?>" rel="stylesheet">

    <!-- Warehouse Components CSS -->
    <link type="text/css" href="<?php echo e(asset('admin-assets/css/warehouse-components.css')); ?>" rel="stylesheet">

    <!-- Custom Brand & Navbar Styles -->
    <style>
        /* Material Icons fix */
        .material-icons {
            font-family: 'Material Icons', 'Material Icons Fallback', sans-serif !important;
            font-weight: normal;
            font-style: normal;
            font-size: 24px;
            line-height: 1;
            letter-spacing: normal;
            text-transform: none;
            display: inline-block;
            white-space: nowrap;
            word-wrap: normal;
            direction: ltr;
            -webkit-font-feature-settings: 'liga';
            -webkit-font-smoothing: antialiased;
            text-rendering: optimizeLegibility;
            -moz-osx-font-smoothing: grayscale;
            font-feature-settings: 'liga';
        }

        /* Navbar fixes */
        .navbar {
            z-index: 1030;
        }

        .navbar-brand {
            font-size: 1.25rem;
        }

        .navbar-nav .dropdown-menu {
            min-width: 250px;
            border: none;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }

        /* Fix dropdown positioning */
        .navbar-nav .nav-item.dropdown {
            position: relative;
        }

        .navbar-nav .dropdown-menu {
            position: absolute !important;
            top: 100% !important;
            right: 0 !important;
            left: auto !important;
            transform: translateY(5px) !important;
            display: none;
        }

        .navbar-nav .dropdown-menu.show {
            display: block !important;
            opacity: 1 !important;
            visibility: visible !important;
            transform: translateY(5px) !important;
            background-color: white !important;
            border: 1px solid rgba(0,0,0,0.15) !important;
            border-radius: 0.375rem !important;
            z-index: 9999 !important;
            min-width: 250px !important;
            max-width: 300px !important;
        }

        /* Ensure navbar container doesn't clip the dropdown */
        .navbar {
            overflow: visible !important;
        }

        .navbar .container-fluid {
            overflow: visible !important;
        }

        /* Force dropdown to be visible in all scenarios */
        #navbarDropdown + .dropdown-menu {
            z-index: 10000 !important;
            position: fixed !important;
            top: 70px !important;
            right: 15px !important;
            left: auto !important;
            margin-top: 0 !important;
            min-top: 60px !important;
        }

        /* Prevent any negative top positioning */
        #navbarDropdown + .dropdown-menu.show {
            top: 70px !important;
            min-height: auto !important;
            background-color: white !important;
            border: 1px solid #dee2e6 !important;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
            transform: none !important;
        }

        /* Ensure the dropdown is always visible when shown */
        .dropdown-menu.show {
            z-index: 99999 !important;
            opacity: 1 !important;
            pointer-events: auto !important;
            visibility: visible !important;
            isolation: isolate !important;
        }

        /* Create a new stacking context for the navbar dropdown */
        .navbar .nav-item.dropdown {
            position: relative;
            z-index: 100000 !important;
            isolation: isolate !important;
        }

        /* Create a completely new dropdown that bypasses all conflicts */
        #custom-profile-dropdown {
            position: fixed !important;
            top: 70px !important;
            right: 15px !important;
            width: 280px !important;
            background: white !important;
            border: 1px solid #dee2e6 !important;
            border-radius: 0.375rem !important;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
            z-index: 999999 !important;
            display: none !important;
            padding: 0 !important;
            margin: 0 !important;
        }

        #custom-profile-dropdown.show {
            display: block !important;
        }

        #custom-profile-dropdown .profile-info {
            padding: 1rem;
            border-bottom: 1px solid #dee2e6;
            background-color: #f8f9fa;
        }

        #custom-profile-dropdown .profile-links {
            padding: 0.5rem 0;
        }

        #custom-profile-dropdown .profile-links a,
        #custom-profile-dropdown .profile-links button {
            display: block;
            width: 100%;
            padding: 0.75rem 1rem;
            color: #333;
            text-decoration: none;
            border: none;
            background: none;
            text-align: left;
            font-size: 0.875rem;
        }

        #custom-profile-dropdown .profile-links a:hover,
        #custom-profile-dropdown .profile-links button:hover {
            background-color: #f8f9fa;
        }

        .dropdown-header {
            padding: 0.75rem 1rem;
            background-color: #f8f9fa;
        }

        .dropdown-item {
            padding: 0.5rem 1rem;
        }

        .dropdown-item:hover {
            background-color: #f8f9fa;
        }

        /* Responsive navbar brand */
        @media (max-width: 576px) {
            .navbar-brand-text {
                display: none !important;
            }
        }
        @media (max-width: 768px) {
            .navbar-brand-text {
                font-size: 16px !important;
            }
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="layout-default">
    <div class="preloader"></div>

    <!-- Header Layout -->
    <div class="mdk-header-layout js-mdk-header-layout">

        <!-- Header -->
        <div id="header" class="mdk-header js-mdk-header m-0" data-fixed>
            <div class="mdk-header__content">
                <div class="navbar navbar-expand-sm navbar-main navbar-light bg-light pr-0" id="navbar" data-primary>
                    <div class="container-fluid p-0">

                        <!-- Navbar toggler -->
                        <button class="navbar-toggler d-block d-lg-none" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                            <span class="navbar-toggler-icon"></span>
                        </button>

                        <!-- Navbar Brand -->
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="navbar-brand d-flex align-items-center">
                            <img src="<?php echo e(asset($siteSettings['site_logo'] ?? 'assets/images/admin-logo.svg')); ?>" alt="<?php echo e($siteSettings['site_name'] ?? 'UFG'); ?> Logo" style="height: 52px;" class="navbar-brand-img mr-2">
                            <span class="navbar-brand-text font-weight-bold" style="font-size: 18px; color: #2c3e50;"><?php echo e($siteSettings['site_name'] ?? 'KCG Inventory'); ?></span>
                        </a>

                        <!-- Search Form -->
                        <form class="search-form d-none d-sm-flex flex" action="#">
                            <button class="btn" type="submit"><i class="material-icons">search</i></button>
                            <input type="text" class="form-control" placeholder="Search">
                        </form>

                        <!-- Navbar Menu -->
                        <div class="collapse navbar-collapse" id="navbarNav">
                            <ul class="navbar-nav ml-auto">
                                <!-- Profile Dropdown -->
                                <li class="nav-item dropdown">
                                    <?php
                                        $user = auth()->user();
                                        $userName = $user ? $user->name : 'KCG Administrator';
                                        $userEmail = $user ? $user->email : 'admin@kcg.com';
                                        $userRole = $user && $user->role ? $user->role->display_name : 'Administrator';
                                        $userInitial = strtoupper(substr($userName, 0, 1));
                                    ?>

                                    <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <div style="width: 32px; height: 32px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; margin-right: 8px;">
                                            <?php echo e($userInitial); ?>

                                        </div>
                                        <div class="d-none d-sm-block text-left">
                                            <div style="font-size: 14px; font-weight: 500; color: #333;"><?php echo e($userName); ?></div>
                                            <div style="font-size: 12px; color: #666;"><?php echo e($userRole); ?></div>
                                        </div>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                        <h6 class="dropdown-header">
                                            <div class="d-flex align-items-center">
                                                <div style="width: 40px; height: 40px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; margin-right: 12px;">
                                                    <?php echo e($userInitial); ?>

                                                </div>
                                                <div>
                                                    <div style="font-weight: 600;"><?php echo e($userName); ?></div>
                                                    <small class="text-muted"><?php echo e($userEmail); ?></small>
                                                </div>
                                            </div>
                                        </h6>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item" href="<?php echo e(route('admin.profile') ?? '#'); ?>">
                                            <i class="material-icons mr-2" style="font-size: 18px;">person</i>
                                            Profile Settings
                                        </a>
                                        <a class="dropdown-item" href="#" onclick="alert('Help center coming soon!'); return false;">
                                            <i class="material-icons mr-2" style="font-size: 18px;">help</i>
                                            Help Center
                                        </a>
                                        <div class="dropdown-divider"></div>
                                        <form method="POST" action="<?php echo e(route('admin.logout')); ?>" class="m-0">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="dropdown-item text-danger">
                                                <i class="material-icons mr-2" style="font-size: 18px;">logout</i>
                                                Sign Out
                                            </button>
                                        </form>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Header Layout Content -->
        <div class="mdk-header-layout__content">
            <div class="mdk-drawer-layout js-mdk-drawer-layout" data-push data-responsive-width="992px">
                <div class="mdk-drawer-layout__content page">

                    <!-- Page Heading -->
                    <div class="container-fluid page__heading-container">
                        <div class="page__heading">
                            <div class="mb-3">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb mb-0">
                                        <?php echo $__env->yieldContent('breadcrumb'); ?>
                                    </ol>
                                </nav>
                            </div>
                            <?php if(View::hasSection('page-title')): ?>
                                <?php echo $__env->yieldContent('page-title'); ?>
                            <?php else: ?>
                                <div class="d-flex justify-content-between align-items-center">
                                    <?php echo $__env->yieldContent('page-actions'); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Page Content -->
                    <div class="container-fluid page__container">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo e(session('success')); ?>

                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>
                        
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>
                        
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>

                </div>

                <!-- Sidebar -->
                <div class="mdk-drawer js-mdk-drawer" id="default-drawer" data-align="start">
                    <div class="mdk-drawer__content">
                        <div class="sidebar sidebar-light sidebar-left sidebar-p-t" data-perfect-scrollbar>
                            <div>
                                <div class="sidebar-heading">Menu</div>
                                
                                <ul class="sidebar-menu">
                                    <!-- Dashboard -->
                                    <li class="sidebar-menu-item <?php echo e(request()->is('admin/dashboard') ? 'active' : ''); ?>">
                                        <a class="sidebar-menu-button" href="<?php echo e(route('admin.dashboard')); ?>">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">dashboard</i>
                                            <span class="sidebar-menu-text">Dashboard</span>
                                        </a>
                                    </li>

                                    <!-- Warehouse Section -->
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.access')): ?>
                                    <div class="sidebar-heading mt-3">
                                        <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">inventory_2</i>
                                        Warehouse
                                    </div>
                                    <hr class="sidebar-divider">

                                    <!-- Suppliers -->
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.suppliers.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/suppliers*') ? 'active' : ''); ?>">
                                        <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.suppliers.index')); ?>">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">business</i>
                                            <span class="sidebar-menu-text">Suppliers</span>
                                        </a>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Projects -->
                                    <?php if(auth()->user()->can('warehouse.projects.view') || auth()->user()->can('warehouse.project-divisions.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/projects*') || request()->is('warehouse/project-divisions*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#projects_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">work</i>
                                            <span class="sidebar-menu-text">Projects</span>
                                            <i class="material-icons ml-auto sidebar-menu-toggle-icon"><?php echo e(request()->is('warehouse/projects*') || request()->is('warehouse/project-divisions*') ? 'keyboard_arrow_up' : 'keyboard_arrow_down'); ?></i>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/projects*') || request()->is('warehouse/project-divisions*') ? 'show' : ''); ?>" id="projects_menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.projects.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/projects*') && !request()->is('warehouse/project-divisions*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.projects.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Projects</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.project-divisions.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/project-divisions*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.project-divisions.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Project Divisions</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Items -->
                                    <?php if(auth()->user()->can('warehouse.items.view') || auth()->user()->can('warehouse.item-categories.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/items*') || request()->is('warehouse/item-categories*') || request()->is('warehouse/item-types*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#items_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">inventory_2</i>
                                            <span class="sidebar-menu-text">Items</span>
                                            <i class="material-icons ml-auto sidebar-menu-toggle-icon"><?php echo e(request()->is('warehouse/items*') || request()->is('warehouse/item-categories*') || request()->is('warehouse/item-types*') ? 'keyboard_arrow_up' : 'keyboard_arrow_down'); ?></i>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/items*') || request()->is('warehouse/item-categories*') || request()->is('warehouse/item-types*') ? 'show' : ''); ?>" id="items_menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.item-categories.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/item-categories*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.item-categories.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Item Categories</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.items.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/item-types*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.item-types.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Item Types</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.items.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/items*') && !request()->is('warehouse/item-categories*') && !request()->is('warehouse/item-types*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.items.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Items</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Inventory -->
                                    <?php if(auth()->user()->can('warehouse.inventory.view') || auth()->user()->can('warehouse.inventory.adjust') || auth()->user()->can('warehouse.inventory.transfer') || auth()->user()->can('warehouse.inventory.count')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#inventory_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">inventory</i>
                                            <span class="sidebar-menu-text">Inventory</span>
                                            <i class="material-icons ml-auto sidebar-menu-toggle-icon">keyboard_arrow_down</i>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/inventory*') ? 'show' : ''); ?>" id="inventory_menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory') && !request()->is('warehouse/inventory/*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Dashboard</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/low-stock*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.low-stock')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Low Stock Alerts</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.adjust')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/adjustments*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.adjustments')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Stock Adjustments</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.count')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/physical-count*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.physical-count')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Cycle Counting</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/valuation*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.valuation')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Inventory Valuation</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/aging-report*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.aging-report')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Aging Report</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Enhanced Incoming Operations -->
                                    <?php if(auth()->user()->can('warehouse.incoming.view') || auth()->user()->can('warehouse.incoming.create') || auth()->user()->can('warehouse.incoming.edit')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/incoming-operations*') || request()->is('warehouse/supplier-delivery*') || request()->is('warehouse/site-return*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#incoming_operations_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">input</i>
                                            <span class="sidebar-menu-text">Incoming Operations</span>
                                            <i class="material-icons ml-auto sidebar-menu-toggle-icon"><?php echo e(request()->is('warehouse/incoming-operations*') || request()->is('warehouse/supplier-delivery*') || request()->is('warehouse/site-return*') ? 'keyboard_arrow_up' : 'keyboard_arrow_down'); ?></i>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/incoming-operations*') || request()->is('warehouse/supplier-delivery*') || request()->is('warehouse/site-return*') ? 'show' : ''); ?>" id="incoming_operations_menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/incoming-operations') && !request()->has('type') && !request()->has('operation_type') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.incoming-operations.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Dashboard</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/supplier-delivery*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.supplier-delivery.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Supplier Deliveries</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/site-return*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.site-return.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Site Returns</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Outgoing Transactions -->
                                    <?php if(auth()->user()->can('warehouse.outgoing.view') || auth()->user()->can('warehouse.outgoing.create') || auth()->user()->can('warehouse.outgoing.edit')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/outgoing*') || request()->is('warehouse/transfer-requests*') || request()->is('warehouse/transfer-issues*') || request()->is('warehouse/direct-deliveries*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#outgoing_transactions_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">output</i>
                                            <span class="sidebar-menu-text">Outgoing Transactions</span>
                                            <i class="material-icons ml-auto sidebar-menu-toggle-icon"><?php echo e(request()->is('warehouse/outgoing*') || request()->is('warehouse/transfer-requests*') || request()->is('warehouse/transfer-issues*') || request()->is('warehouse/direct-deliveries*') ? 'keyboard_arrow_up' : 'keyboard_arrow_down'); ?></i>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/outgoing*') || request()->is('warehouse/transfer-requests*') || request()->is('warehouse/transfer-issues*') || request()->is('warehouse/direct-deliveries*') ? 'show' : ''); ?>" id="outgoing_transactions_menu">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/outgoing') && !request()->is('warehouse/outgoing/*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.outgoing.index')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Dashboard</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.create')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/material-requests*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.material-requests')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Material Request</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.view')): ?>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/inventory/material-issued*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.inventory.material-issued')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Material Issue</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>

                                        </ul>
                                    </li>
                                    <?php endif; ?>


                                    <!-- Reports -->
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.reports.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/reports*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#reports_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">assessment</i>
                                            <span class="sidebar-menu-text">Reports</span>
                                            <i class="material-icons ml-auto sidebar-menu-toggle-icon"><?php echo e(request()->is('warehouse/reports*') ? 'keyboard_arrow_up' : 'keyboard_arrow_down'); ?></i>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('warehouse/reports*') ? 'show' : ''); ?>" id="reports_menu">
                                            <li class="sidebar-menu-item <?php echo e(request()->routeIs('warehouse.reports.inventory') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.reports.inventory')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Inventory Report</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->routeIs('warehouse.reports.incoming') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.reports.incoming')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Incoming Materials Report</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->routeIs('warehouse.reports.returns') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.reports.returns')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Returns Goods Report</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->routeIs('warehouse.reports.outgoing') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.reports.outgoing')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Outgoing Material Report</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->routeIs('warehouse.reports.transactions') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.reports.transactions')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Transaction Report</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->routeIs('warehouse.reports.stock-on-project*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.reports.stock-on-project')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Stock on Project</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>
                                    <?php endif; ?>


                                    <!-- Warehouse Settings -->
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.settings.view')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('warehouse/settings*') ? 'active' : ''); ?>">
                                        <a class="sidebar-menu-button" href="<?php echo e(route('warehouse.settings.index')); ?>">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">tune</i>
                                            <span class="sidebar-menu-text">Warehouse Settings</span>
                                        </a>
                                    </li>
                                    <?php endif; ?>
                                    <?php endif; ?>

                                    <!-- Careers Management Removed -->

                                    <!-- Media Management Removed -->

                                    <!-- Product Management Removed -->

                                    <!-- Reports Management Removed -->

                                    <!-- Pages Management Removed -->

                                    <!-- Site Settings -->
                                    <?php if(auth()->user()->hasPermission('view_settings') || auth()->user()->hasPermission('manage_settings')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('admin/site-settings*') ? 'active' : ''); ?>">
                                        <a class="sidebar-menu-button" href="<?php echo e(route('admin.site-settings.index')); ?>">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">settings</i>
                                            <span class="sidebar-menu-text">Site Settings</span>
                                        </a>
                                    </li>
                                    <?php endif; ?>

                                    <!-- Investor Inquiries Removed -->

                                    <!-- Team Members Removed -->

                                    <!-- Contact Inquiries Removed -->

                                    <!-- User System -->
                                    <?php if(auth()->user()->hasPermission('view_users') || auth()->user()->hasPermission('manage_roles') || auth()->user()->hasPermission('manage_departments') || auth()->user()->hasPermission('view_activity_logs')): ?>
                                    <li class="sidebar-menu-item <?php echo e(request()->is('admin/users*') || request()->is('admin/roles*') || request()->is('admin/permissions*') || request()->is('admin/departments*') || request()->is('admin/activity-logs*') ? 'active open' : ''); ?>">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#user_system_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">admin_panel_settings</i>
                                            <span class="sidebar-menu-text">User System</span>
                                            <i class="material-icons ml-auto sidebar-menu-toggle-icon"><?php echo e(request()->is('admin/users*') || request()->is('admin/roles*') || request()->is('admin/permissions*') || request()->is('admin/departments*') || request()->is('admin/activity-logs*') ? 'keyboard_arrow_up' : 'keyboard_arrow_down'); ?></i>
                                        </a>
                                        <ul class="sidebar-submenu collapse <?php echo e(request()->is('admin/users*') || request()->is('admin/roles*') || request()->is('admin/permissions*') || request()->is('admin/departments*') || request()->is('admin/activity-logs*') ? 'show' : ''); ?>" id="user_system_menu">
                                            
                                            <?php if(auth()->user()->hasPermission('view_users')): ?>
                                            <!-- Users Management Section -->
                                            <li class="sidebar-menu-item">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">USERS</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/users') && !request()->has('action') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.users')); ?>">
                                                    <span class="sidebar-menu-text ml-3">All Users</span>
                                                </a>
                                            </li>
                                            <?php if(auth()->user()->hasPermission('create_users')): ?>
                                            <li class="sidebar-menu-item">
                                                <a class="sidebar-menu-button" href="#" data-toggle="modal" data-target="#createUserModal">
                                                    <span class="sidebar-menu-text ml-3">Add User</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                            
                                            <?php if(auth()->user()->hasPermission('manage_roles')): ?>
                                            <!-- Roles & Permissions Section -->
                                            <li class="sidebar-menu-item mt-2">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">ROLES & PERMISSIONS</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/roles') && !request()->is('admin/roles/create') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.roles')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Manage Roles</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/roles/create') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.roles.create')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Create Role</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/permissions') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.permissions')); ?>">
                                                    <span class="sidebar-menu-text ml-3">View Permissions</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            
                                            <?php if(auth()->user()->hasPermission('manage_departments')): ?>
                                            <!-- Departments Section -->
                                            <li class="sidebar-menu-item mt-2">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">ORGANIZATION</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/departments*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.departments')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Departments</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                            
                                            <?php if(auth()->user()->hasPermission('view_activity_logs')): ?>
                                            <!-- Activity Logs Section -->
                                            <li class="sidebar-menu-item mt-2">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">ACTIVITY</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item <?php echo e(request()->is('admin/activity-logs*') ? 'active' : ''); ?>">
                                                <a class="sidebar-menu-button" href="<?php echo e(route('admin.activity-logs')); ?>">
                                                    <span class="sidebar-menu-text ml-3">Activity Logs</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>

                            <!-- FlowDash User Account Component -->
                            <div class="d-flex align-items-center sidebar-p-a border-bottom sidebar-account">
                                <a href="#" class="flex d-flex align-items-center text-underline-0 text-body">
                                    <span class="avatar avatar-sm mr-2">
                                        <span class="avatar-title rounded-circle" style="background-color: #038BB9; color: white;">
                                            <?php echo e(substr(auth()->user()->name ?? 'A', 0, 1)); ?>

                                        </span>
                                    </span>
                                    <span class="flex d-flex flex-column">
                                        <strong><?php echo e(auth()->user()->name ?? 'AUFG Admin'); ?></strong>
                                        <small class="text-muted text-uppercase"><?php echo e(auth()->user()->role->display_name ?? 'User'); ?></small>
                                    </span>
                                </a>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php echo $__env->yieldContent('modals'); ?>
    <?php echo $__env->yieldContent('floating-tracker'); ?>

    <!-- Page Loading Overlay -->
    <div class="page-loading-overlay" id="pageLoadingOverlay">
        <div class="loading-spinner"></div>
        <div class="loading-text">Loading...</div>
    </div>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>

    <!-- DataTables JavaScript with Fallback Loading -->
    <script>
        window.dataTablesLoaded = 0;
        window.dataTablesRequired = 4;

        function loadDataTablesFallback() {
            console.log('🔄 Loading DataTables fallback from cdnjs...');

            const fallbackScripts = [
                'https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js',
                'https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/dataTables.bootstrap4.min.js'
            ];

            let loadedCount = 0;
            fallbackScripts.forEach(function(src, index) {
                const script = document.createElement('script');
                script.src = src;
                script.onload = function() {
                    loadedCount++;
                    console.log(`✅ Fallback script ${index + 1} loaded`);
                    if (loadedCount === fallbackScripts.length) {
                        console.log('📦 All fallback DataTables scripts loaded');
                        setTimeout(function() {
                            if (typeof $ !== 'undefined' && typeof $.fn.DataTable !== 'undefined') {
                                console.log('✅ Fallback DataTables is ready!');
                                window.dispatchEvent(new CustomEvent('dataTablesReady'));
                            }
                        }, 100);
                    }
                };
                script.onerror = function() {
                    console.error(`❌ Fallback script ${index + 1} failed to load`);
                };
                document.head.appendChild(script);
            });
        }

        function onDataTableScriptLoad() {
            window.dataTablesLoaded++;
            console.log(`✅ DataTables script loaded (${window.dataTablesLoaded}/${window.dataTablesRequired})`);

            if (window.dataTablesLoaded === window.dataTablesRequired) {
                console.log('📦 All primary DataTables scripts loaded');
                setTimeout(function() {
                    if (typeof $ !== 'undefined' && typeof $.fn.DataTable !== 'undefined') {
                        console.log('✅ Primary DataTables is ready!');
                        window.dispatchEvent(new CustomEvent('dataTablesReady'));
                    } else {
                        console.warn('⚠️ DataTables scripts loaded but not available, trying fallback...');
                        loadDataTablesFallback();
                    }
                }, 100);
            }
        }

        function onDataTableScriptError(scriptName) {
            console.error(`❌ ${scriptName} failed to load`);
            window.dataTablesRequired--;

            // If any script fails, try fallback after a short delay
            setTimeout(function() {
                if (window.dataTablesLoaded < 2) { // If we don't have basic functionality
                    loadDataTablesFallback();
                }
            }, 1000);
        }
    </script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/datatables.net@1.13.4/js/jquery.dataTables.min.js"
            onerror="onDataTableScriptError('DataTables Core JS');"
            onload="onDataTableScriptLoad();"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/js/dataTables.bootstrap4.min.js"
            onerror="onDataTableScriptError('DataTables Bootstrap JS');"
            onload="onDataTableScriptLoad();"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/datatables.net-responsive@2.4.1/js/dataTables.responsive.min.js"
            onerror="onDataTableScriptError('DataTables Responsive JS');"
            onload="onDataTableScriptLoad();"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/datatables.net-responsive-bs4@2.4.1/js/responsive.bootstrap4.min.js"
            onerror="onDataTableScriptError('DataTables Responsive Bootstrap JS');"
            onload="onDataTableScriptLoad();"></script>

    <!-- PerfectScrollbar (load before app.js) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/perfect-scrollbar/1.5.5/css/perfect-scrollbar.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/perfect-scrollbar/1.5.5/perfect-scrollbar.min.js"></script>

    <!-- Admin Assets (only the ones that exist) -->
    <script src="<?php echo e(asset('admin-assets/vendor/dom-factory.js')); ?>"></script>
    <script src="<?php echo e(asset('admin-assets/vendor/material-design-kit.js')); ?>"></script>
    <script src="<?php echo e(asset('admin-assets/js/app.js')); ?>"></script>
    
    <!-- Admin Custom JavaScript -->
    <script src="<?php echo e(asset('admin-assets/js/admin-custom.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('scripts'); ?>

    <!-- DataTables Global Configuration -->
    <script>
        let dataTablesInitialized = false;

        function initializeDataTablesGlobally() {
            if (dataTablesInitialized) {
                console.log('⚠️ DataTables already initialized, skipping...');
                return;
            }

            if (typeof $ === 'undefined' || typeof $.fn.DataTable === 'undefined') {
                console.error('❌ Cannot initialize DataTables: library not available');
                return;
            }

            console.log('🔧 Initializing DataTables globally...');

            // Set DataTables default configuration
            $.extend(true, $.fn.dataTable.defaults, {
                responsive: true,
                pageLength: 25,
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                language: {
                    search: "Search:",
                    lengthMenu: "Show _MENU_ entries",
                    info: "Showing _START_ to _END_ of _TOTAL_ entries",
                    infoEmpty: "Showing 0 to 0 of 0 entries",
                    infoFiltered: "(filtered from _MAX_ total entries)",
                    paginate: {
                        first: "First",
                        last: "Last",
                        next: "Next",
                        previous: "Previous"
                    }
                },
                dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" +
                     "<'row'<'col-sm-12'tr>>" +
                     "<'row'<'col-sm-5'i><'col-sm-7'p>>",
                order: []
            });

            console.log('✅ DataTables global configuration set');

            // Auto-initialize DataTables on tables with 'dataTable' class
            if ($('.dataTable').length > 0) {
                console.log('🔍 Found', $('.dataTable').length, 'tables to auto-initialize');
                $('.dataTable').DataTable();
                console.log('✅ DataTables auto-initialized successfully');
            }

            dataTablesInitialized = true;
        }

        // Listen for the custom dataTablesReady event
        window.addEventListener('dataTablesReady', function() {
            console.log('🎉 DataTables ready event received!');
            initializeDataTablesGlobally();
        });

        // Also try on document ready as fallback
        $(document).ready(function() {
            console.log('📄 Document ready, checking if DataTables is available...');

            // Wait a bit then check if DataTables is available
            setTimeout(function() {
                if (typeof $ !== 'undefined' && typeof $.fn.DataTable !== 'undefined' && !dataTablesInitialized) {
                    console.log('✅ DataTables found on document ready, initializing...');
                    initializeDataTablesGlobally();
                } else if (!dataTablesInitialized) {
                    console.log('⏳ DataTables not ready yet, waiting for dataTablesReady event...');
                }
            }, 500);
        });
    </script>

    <!-- Material Icons Debug Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Check if Material Icons font is loaded
            setTimeout(function() {
                var testIcon = document.createElement('i');
                testIcon.className = 'material-icons';
                testIcon.textContent = 'home';
                testIcon.style.position = 'absolute';
                testIcon.style.left = '-1000px';
                testIcon.style.fontSize = '24px';
                document.body.appendChild(testIcon);

                // Check if the icon rendered properly
                var computedStyle = window.getComputedStyle(testIcon);
                var fontFamily = computedStyle.getPropertyValue('font-family');

                if (!fontFamily.includes('Material Icons')) {
                    console.warn('Material Icons font not loaded properly. Font-family:', fontFamily);
                    // Add fallback class to body
                    document.body.classList.add('material-icons-fallback');
                } else {
                    console.log('Material Icons loaded successfully');
                }

                document.body.removeChild(testIcon);
            }, 2000);
        });
    </script>

    <!-- Material Icons Fallback CSS -->
    <style>
        /* Fallback for when Material Icons don't load */
        .material-icons-fallback .material-icons {
            font-family: Arial, sans-serif;
            font-size: 16px;
            font-weight: bold;
        }

        .material-icons-fallback .material-icons:before {
            content: "●";
            color: #666;
        }
    </style>

    <!-- Basic initialization - main dropdown handling is in admin-custom.js -->
    <script>
        $(document).ready(function() {
            console.log('🔧 Layout: Basic dropdown setup initialized');

            // Create custom profile dropdown
            let customDropdown = null;

            $('#navbarDropdown').on('click', function(e) {
                e.preventDefault();

                // Remove existing dropdown if any
                if (customDropdown) {
                    customDropdown.remove();
                }

                // Get user data from existing dropdown
                const userName = '<?php echo e($userName ?? "KCG Administrator"); ?>';
                const userEmail = '<?php echo e($userEmail ?? "admin@kcg.com"); ?>';
                const userInitial = '<?php echo e($userInitial ?? "K"); ?>';

                // Create custom dropdown HTML
                customDropdown = $(`
                    <div id="custom-profile-dropdown" class="show">
                        <div class="profile-info">
                            <div style="display: flex; align-items: center;">
                                <div style="width: 40px; height: 40px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; margin-right: 12px;">
                                    ${userInitial}
                                </div>
                                <div>
                                    <div style="font-weight: 600; color: #333;">${userName}</div>
                                    <small style="color: #666;">${userEmail}</small>
                                </div>
                            </div>
                        </div>
                        <div class="profile-links">
                            <a href="<?php echo e(route('admin.profile') ?? '#'); ?>">
                                <i class="material-icons mr-2" style="font-size: 18px;">person</i>
                                Profile Settings
                            </a>
                            <a href="#" onclick="alert('Help center coming soon!'); return false;">
                                <i class="material-icons mr-2" style="font-size: 18px;">help</i>
                                Help Center
                            </a>
                            <hr style="margin: 0.5rem 0;">
                            <form method="POST" action="<?php echo e(route('admin.logout')); ?>" style="margin: 0;">
                                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                <button type="submit" style="color: #dc3545; width: 100%; text-align: left; border: none; background: none; padding: 0.75rem 1rem; font-size: 0.875rem;">
                                    <i class="material-icons mr-2" style="font-size: 18px;">logout</i>
                                    Sign Out
                                </button>
                            </form>
                        </div>
                    </div>
                `);

                // Append to body
                $('body').append(customDropdown);

                console.log('👤 Custom profile dropdown created and shown');
            });

            // Close dropdown when clicking outside
            $(document).on('click', function(e) {
                if (!$(e.target).closest('.nav-item.dropdown, #custom-profile-dropdown').length) {
                    $('#custom-profile-dropdown').remove();
                    customDropdown = null;
                    console.log('👤 Custom profile dropdown closed');
                }
            });

            // Prevent Select2 from interfering with Bootstrap dropdowns
            $(document).on('select2:open', function(e) {
                $('.dropdown-menu').removeClass('show').hide();
                console.log('🔧 Closed dropdowns due to Select2 opening');
            });
        });
    </script>
</body>
</html><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/layouts/admin-simple.blade.php ENDPATH**/ ?>