<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Page;

class CheckPageStatus
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $routeName = $request->route()->getName();
        
        // Check if this route has a corresponding page in the database
        $page = Page::where('route_name', $routeName)->first();
        
        if ($page && !$page->is_enabled) {
            // Page exists but is disabled
            abort(404);
        }
        
        // If page exists and is enabled, or page doesn't exist in DB, continue
        return $next($request);
    }
}