<?php

require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use Illuminate\Support\Facades\DB;

try {
    echo "=== Inventory Flow Analysis ===" . PHP_EOL;

    // Check outgoing transactions
    $outgoingCount = DB::table('outgoing_transactions')->count();
    echo "Total outgoing transactions: " . $outgoingCount . PHP_EOL;

    $outgoingWithProject = DB::table('outgoing_transactions')->whereNotNull('project_id')->count();
    echo "Outgoing transactions with project_id: " . $outgoingWithProject . PHP_EOL;

    // Check outgoing items
    $outgoingItems = DB::table('outgoing_items')->count();
    echo "Total outgoing items: " . $outgoingItems . PHP_EOL;

    // Check incoming operations
    $incomingOps = DB::table('incoming_operations')->count();
    echo "Total incoming operations: " . $incomingOps . PHP_EOL;

    $incomingOpItems = DB::table('incoming_operation_items')->count();
    echo "Total incoming operation items: " . $incomingOpItems . PHP_EOL;

    // Check inventory table
    $inventoryCount = DB::table('inventory')->count();
    echo "Total inventory records: " . $inventoryCount . PHP_EOL;

    // Check stock movements
    $stockMovements = DB::table('stock_movements')->count();
    echo "Total stock movements: " . $stockMovements . PHP_EOL;

    echo PHP_EOL . "--- Sample Outgoing Transactions ---" . PHP_EOL;
    $sampleOutgoing = DB::table('outgoing_transactions')
        ->select('id', 'project_id', 'transaction_date', 'status', 'material_request_number')
        ->limit(5)->get();

    foreach ($sampleOutgoing as $out) {
        echo "ID: {$out->id}, Project: {$out->project_id}, Date: {$out->transaction_date}, Status: {$out->status}, MRN: {$out->material_request_number}" . PHP_EOL;
    }

    echo PHP_EOL . "--- Sample Outgoing Items ---" . PHP_EOL;
    $sampleOutItems = DB::table('outgoing_items')
        ->join('outgoing_transactions', 'outgoing_items.outgoing_transaction_id', '=', 'outgoing_transactions.id')
        ->select('outgoing_items.item_id', 'outgoing_items.quantity_requested', 'outgoing_items.quantity_released', 'outgoing_transactions.project_id', 'outgoing_transactions.status')
        ->limit(5)->get();

    foreach ($sampleOutItems as $item) {
        echo "Item: {$item->item_id}, Requested: {$item->quantity_requested}, Released: {$item->quantity_released}, Project: {$item->project_id}, Status: {$item->status}" . PHP_EOL;
    }

    echo PHP_EOL . "--- Sample Stock Movements ---" . PHP_EOL;
    $sampleMovements = DB::table('stock_movements')
        ->select('item_id', 'movement_type', 'reference_type', 'reference_id', 'quantity_moved', 'created_at')
        ->limit(5)->get();

    foreach ($sampleMovements as $move) {
        echo "Item: {$move->item_id}, Type: {$move->movement_type}, Ref: {$move->reference_type}:{$move->reference_id}, Qty: {$move->quantity_moved}, Date: {$move->created_at}" . PHP_EOL;
    }

    // Check for site returns
    echo PHP_EOL . "--- Site Return Data ---" . PHP_EOL;
    $returnTrans = DB::table('return_transactions')->count();
    echo "Return transactions: " . $returnTrans . PHP_EOL;

    $returnItems = DB::table('return_items')->count();
    echo "Return items: " . $returnItems . PHP_EOL;

    // Check incoming operations with site returns
    $siteReturns = DB::table('incoming_operations')->where('operation_type', 'site_return')->count();
    echo "Incoming operations (site returns): " . $siteReturns . PHP_EOL;

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . PHP_EOL;
}