<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(\Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = \Illuminate\Http\Request::capture()
);

use App\Models\Warehouse\OutgoingTransaction;
use App\Models\Warehouse\OutgoingItem;
use App\Models\Warehouse\OutgoingFulfillment;

// Get transaction with ID 1
$transaction = OutgoingTransaction::with(['items.item'])->find(1);

if ($transaction) {
    echo "Transaction ID: " . $transaction->id . "\n";
    echo "Status: " . $transaction->status . "\n";
    echo "Material Request Number: " . $transaction->material_request_number . "\n";
    echo "Notes: " . $transaction->notes . "\n\n";

    echo "Items:\n";
    foreach ($transaction->items as $item) {
        echo "  - Item ID: " . $item->item_id . "\n";
        echo "    Code: " . ($item->item->item_code ?? 'N/A') . "\n";
        echo "    Requested: " . $item->quantity_requested . "\n";
        echo "    Released: " . $item->quantity_released . "\n\n";
    }

    echo "Fulfillments:\n";
    $fulfillments = OutgoingFulfillment::where('outgoing_transaction_id', $transaction->id)->get();
    foreach ($fulfillments as $fulfillment) {
        echo "  - Item ID: " . $fulfillment->item_id . "\n";
        echo "    Quantity: " . $fulfillment->quantity_fulfilled . "\n";
        echo "    Type: " . $fulfillment->fulfillment_type . "\n";
        echo "    Created: " . $fulfillment->created_at . "\n\n";
    }

    // Calculate totals
    $totalRequested = $transaction->items->sum('quantity_requested');
    $totalFulfilled = $fulfillments->sum('quantity_fulfilled');
    echo "Total Requested: " . $totalRequested . "\n";
    echo "Total Fulfilled: " . $totalFulfilled . "\n";
    echo "Remaining: " . ($totalRequested - $totalFulfilled) . "\n";
} else {
    echo "Transaction not found.\n";
}